"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFeature = void 0;
var _i18n = require("@kbn/i18n");
var _app = require("../common/constants/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerFeature = home => {
  // register ML so it appears on the Kibana home page
  home.featureCatalogue.register({
    id: _app.PLUGIN_ID,
    title: _i18n.i18n.translate('xpack.ml.machineLearningTitle', {
      defaultMessage: 'Machine Learning'
    }),
    subtitle: _i18n.i18n.translate('xpack.ml.machineLearningSubtitle', {
      defaultMessage: 'Model, predict, and detect.'
    }),
    description: _i18n.i18n.translate('xpack.ml.machineLearningDescription', {
      defaultMessage: 'Automatically model the normal behavior of your time series data to detect anomalies.'
    }),
    icon: 'machineLearningApp',
    path: '/app/ml',
    showOnHomePage: false,
    category: 'data',
    solutionId: 'kibana',
    order: 500
  });
};
exports.registerFeature = registerFeature;