"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalySourceFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/maps-plugin/common");
var _http_service = require("../application/services/http_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class AnomalySourceFactory {
  constructor(getStartServices, canGetJobs) {
    (0, _defineProperty2.default)(this, "type", _common.SOURCE_TYPES.ES_ML_ANOMALIES);
    this.getStartServices = getStartServices;
    this.canGetJobs = canGetJobs;
    this.canGetJobs = canGetJobs;
  }
  async getServices() {
    const [coreStart] = await this.getStartServices();
    const {
      mlApiServicesProvider
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../application/services/ml_api_service')));
    const httpService = new _http_service.HttpService(coreStart.http);
    const mlResultsService = mlApiServicesProvider(httpService).results;
    return {
      mlResultsService
    };
  }
  async create() {
    const {
      mlResultsService
    } = await this.getServices();
    const {
      AnomalySource
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_source')));
    AnomalySource.mlResultsService = mlResultsService;
    AnomalySource.canGetJobs = this.canGetJobs;
    return AnomalySource;
  }
}
exports.AnomalySourceFactory = AnomalySourceFactory;