"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _notifications = require("./formatters/notifications");
var _locator = require("../../common/constants/locator");
var _formatters = require("./formatters");
var _trained_models = require("./formatters/trained_models");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MlLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _locator.ML_APP_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      let path = '';
      switch (params.page) {
        case _locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE:
          path = (0, _formatters.formatAnomalyDetectionJobManagementUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.ANOMALY_EXPLORER:
          path = (0, _formatters.formatExplorerUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_TYPE:
          path = (0, _formatters.formatAnomalyDetectionCreateJobSelectType)('', params.pageState);
          break;
        case _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_INDEX:
          path = (0, _formatters.formatAnomalyDetectionCreateJobSelectIndex)('', params.pageState);
          break;
        case _locator.ML_PAGES.SINGLE_METRIC_VIEWER:
          path = (0, _formatters.formatSingleMetricViewerUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE:
          path = (0, _formatters.formatDataFrameAnalyticsJobManagementUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.DATA_FRAME_ANALYTICS_CREATE_JOB:
          path = (0, _formatters.formatDataFrameAnalyticsCreateJobUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP:
          path = (0, _formatters.formatDataFrameAnalyticsMapUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION:
          path = (0, _formatters.formatDataFrameAnalyticsExplorationUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.TRAINED_MODELS_MANAGE:
          path = (0, _trained_models.formatTrainedModelsManagementUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.MEMORY_USAGE:
          path = (0, _trained_models.formatMemoryUsageUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB:
        case _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_RECOGNIZER:
        case _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_ADVANCED:
        case _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_FROM_LENS:
        case _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_FROM_MAP:
        case _locator.ML_PAGES.DATA_VISUALIZER:
        case _locator.ML_PAGES.DATA_VISUALIZER_FILE:
        case _locator.ML_PAGES.DATA_VISUALIZER_INDEX_VIEWER:
        case _locator.ML_PAGES.DATA_VISUALIZER_INDEX_SELECT:
        case _locator.ML_PAGES.AIOPS:
        case _locator.ML_PAGES.AIOPS_EXPLAIN_LOG_RATE_SPIKES:
        case _locator.ML_PAGES.AIOPS_EXPLAIN_LOG_RATE_SPIKES_INDEX_SELECT:
        case _locator.ML_PAGES.AIOPS_LOG_CATEGORIZATION:
        case _locator.ML_PAGES.AIOPS_LOG_CATEGORIZATION_INDEX_SELECT:
        case _locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION:
        case _locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION_INDEX_SELECT:
        case _locator.ML_PAGES.OVERVIEW:
        case _locator.ML_PAGES.SETTINGS:
        case _locator.ML_PAGES.FILTER_LISTS_MANAGE:
        case _locator.ML_PAGES.FILTER_LISTS_NEW:
        case _locator.ML_PAGES.CALENDARS_MANAGE:
        case _locator.ML_PAGES.CALENDARS_NEW:
        case _locator.ML_PAGES.ACCESS_DENIED:
          path = (0, _formatters.formatGenericMlUrl)('', params.page, params.pageState);
          break;
        case _locator.ML_PAGES.FILTER_LISTS_EDIT:
          path = (0, _formatters.formatEditFilterUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.CALENDARS_EDIT:
          path = (0, _formatters.formatEditCalendarUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.NOTIFICATIONS:
          path = (0, _notifications.formatNotificationsUrl)('', params.pageState);
          break;
        default:
          throw new Error('Page type is not provided or unknown');
      }
      return {
        app: 'ml',
        path,
        state: {}
      };
    });
  }
}
exports.MlLocatorDefinition = MlLocatorDefinition;