"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatNotificationsUrl = formatNotificationsUrl;
var _public = require("@kbn/kibana-utils-plugin/public");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _locator = require("../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatNotificationsUrl(appBasePath, pageState) {
  let url = `${appBasePath}/${_locator.ML_PAGES.NOTIFICATIONS}`;
  if (pageState) {
    const appState = {};
    const globalState = {};
    const {
      level
    } = pageState;
    if (!!level) {
      appState.level = level;
    }
    if ((0, _mlIsPopulatedObject.isPopulatedObject)(globalState)) {
      url = (0, _public.setStateToKbnUrl)('_g', globalState, {
        useHash: false,
        storeInHashQuery: false
      }, url);
    }
    if ((0, _mlIsPopulatedObject.isPopulatedObject)(appState)) {
      url = (0, _public.setStateToKbnUrl)('_a', appState, {
        useHash: false,
        storeInHashQuery: false
      }, url);
    }
  }
  return url;
}