"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompatibleLayer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _job_from_map = require("../../../../../application/jobs/new_job/job_from_map");
var _context = require("../../../lens/context");
var _job_details = require("../../../common/job_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CompatibleLayer = ({
  embeddable,
  layer,
  layerIndex
}) => {
  var _layer$dataView, _layer$dataView2, _layer$splitFieldOpti;
  const [selectedSplitField, setSelectedSplitField] = (0, _react.useState)(null);
  const [createError, setCreateError] = (0, _react.useState)();
  const {
    services: {
      data,
      share,
      uiSettings,
      mlServices: {
        mlApiServices
      }
    }
  } = (0, _context.useMlFromLensKibanaContext)();
  const quickJobCreator = (0, _react.useMemo)(() => new _job_from_map.QuickGeoJobCreator(uiSettings, data.query.timefilter.timefilter, share, mlApiServices),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [data, uiSettings]);
  const createGeoJobInWizard = (0, _react.useCallback)(() => {
    (0, _job_from_map.redirectToGeoJobWizard)(embeddable, layer.dataView.id, layer.geoField, layer.query, selectedSplitField, share);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [layer === null || layer === void 0 ? void 0 : (_layer$dataView = layer.dataView) === null || _layer$dataView === void 0 ? void 0 : _layer$dataView.id, embeddable, selectedSplitField]);
  const createGeoJob = (0, _react.useCallback)(async ({
    jobId,
    bucketSpan,
    embeddable: mapEmbeddable,
    startJob,
    runInRealTime
  }) => {
    try {
      const result = await quickJobCreator.createAndSaveGeoJob({
        jobId,
        bucketSpan,
        embeddable: mapEmbeddable,
        startJob,
        runInRealTime,
        sourceDataView: layer.dataView,
        geoField: layer.geoField,
        layerLevelQuery: layer.query,
        splitField: selectedSplitField
      });
      return result;
    } catch (error) {
      var _error$message;
      // eslint-disable-next-line no-console
      console.error(error);
      setCreateError({
        text: _i18n.i18n.translate('xpack.ml.embeddables.geoJobFlyout.jobCreationError', {
          defaultMessage: 'Job could not be created.'
        }),
        errorText: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : error
      });
      return {
        jobCreated: {
          success: false
        },
        datafeedCreated: {
          success: false
        },
        jobOpened: {
          success: false
        },
        datafeedStarted: {
          success: false
        }
      };
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [quickJobCreator, embeddable, selectedSplitField]);
  const splitFieldSelection = (0, _react.useMemo)(() => {
    const selectedOptions = [];
    if (selectedSplitField) {
      selectedOptions.push({
        label: selectedSplitField,
        field: selectedSplitField
      });
    }
    return selectedOptions;
  }, [selectedSplitField]);
  const onSplitFieldChange = (0, _react.useCallback)(selectedOptions => {
    const option = selectedOptions[0];
    if (typeof option !== 'undefined') {
      setSelectedSplitField(option.field);
    } else {
      setSelectedSplitField(null);
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_job_details.JobDetails, {
    layerIndex: layerIndex,
    createADJob: createGeoJob,
    createADJobInWizard: createGeoJobInWizard,
    embeddable: embeddable,
    incomingCreateError: createError
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "data-test-subj": "mlMapLayerCompatible"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.embeddables.geoJobFlyout.createJobCalloutTitle.multiMetric",
    defaultMessage: "The {geoField} field can be used to create a geo job for {sourceDataViewTitle}",
    values: {
      geoField: layer.geoField,
      sourceDataViewTitle: (_layer$dataView2 = layer.dataView) === null || _layer$dataView2 === void 0 ? void 0 : _layer$dataView2.getIndexPattern()
    }
  })))), (_layer$splitFieldOpti = layer.splitFieldOptions) !== null && _layer$splitFieldOpti !== void 0 && _layer$splitFieldOpti.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": 'mlGeoJobAdditionalSettingsButton',
    id: "additional-section",
    buttonContent: _i18n.i18n.translate('xpack.ml.embeddables.geoJobFlyout.createJobCallout.splitField.title', {
      defaultMessage: 'Optionally select a field to split the data'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.embeddables.geoJobFlyout.selectSplitField",
      defaultMessage: "Split field"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    options: layer.splitFieldOptions,
    selectedOptions: splitFieldSelection,
    onChange: onSplitFieldChange,
    isClearable: true,
    "data-test-subj": "mlGeoJobSplitFieldSelect"
  })))) : null)));
};
exports.CompatibleLayer = CompatibleLayer;