"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensLayerSelectionFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _layer = require("./layer");
var _job_from_lens = require("../../../../application/jobs/new_job/job_from_lens");
var _context = require("../context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LensLayerSelectionFlyout = ({
  onClose,
  embeddable
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      data,
      lens
    }
  } = (0, _context.useMlFromLensKibanaContext)();
  const [layerResults, setLayerResults] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    const visExtractor = new _job_from_lens.VisualizationExtractor();
    visExtractor.getResultLayersFromEmbeddable(embeddable, lens).then(setLayerResults).catch(error => {
      // eslint-disable-next-line no-console
      console.error('Layers could not be extracted from embeddable', error);
      onClose();
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [data, lens, embeddable]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.embeddables.lensLayerFlyout.title",
    defaultMessage: "Create anomaly detection job"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.embeddables.lensLayerFlyout.secondTitle",
    defaultMessage: "Select a compatible layer from the visualization {title} to create an anomaly detection job.",
    values: {
      title: embeddable.getTitle()
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: {
      backgroundColor: euiTheme.colors.lightestShade
    }
  }, layerResults.map((layer, i) => /*#__PURE__*/_react.default.createElement(_layer.Layer, {
    layer: layer,
    layerIndex: i,
    key: layer.id,
    embeddable: embeddable
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.embeddables.lensLayerFlyout.closeButton",
    defaultMessage: "Close"
  }))))));
};
exports.LensLayerSelectionFlyout = LensLayerSelectionFlyout;