"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJobsObservable = getJobsObservable;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _lodash = require("lodash");
var _parse_interval = require("../../../common/util/parse_interval");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getJobsObservable(embeddableInput, anomalyDetectorService, setErrorHandler) {
  return embeddableInput.pipe((0, _operators.pluck)('jobIds'), (0, _operators.distinctUntilChanged)(_lodash.isEqual), (0, _operators.switchMap)(jobsIds => anomalyDetectorService.getJobs$(jobsIds)), (0, _operators.map)(jobs => {
    const explorerJobs = jobs.map(job => {
      var _job$model_plot_confi;
      const bucketSpan = (0, _parse_interval.parseInterval)(job.analysis_config.bucket_span);
      return {
        id: job.job_id,
        selected: true,
        bucketSpanSeconds: bucketSpan.asSeconds(),
        modelPlotEnabled: ((_job$model_plot_confi = job.model_plot_config) === null || _job$model_plot_confi === void 0 ? void 0 : _job$model_plot_confi.enabled) === true
      };
    });
    return explorerJobs;
  }), (0, _operators.catchError)(e => {
    var _e$body;
    setErrorHandler((_e$body = e.body) !== null && _e$body !== void 0 ? _e$body : e);
    return (0, _rxjs.of)(undefined);
  }));
}