"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSwimlaneInputResolver = useSwimlaneInputResolver;
var _react = require("react");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _time_buckets = require("../../application/util/time_buckets");
var _explorer_constants = require("../../application/explorer/explorer_constants");
var _swimlane_container = require("../../application/explorer/swimlane_container");
var _process_filters = require("../common/process_filters");
var _ = require("../..");
var _get_jobs_observable = require("../common/get_jobs_observable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FETCH_RESULTS_DEBOUNCE_MS = 500;
function useSwimlaneInputResolver(embeddableInput$, onInputChange, refresh, services, chartWidth, fromPage, renderCallbacks) {
  const [{
    uiSettings
  },, {
    anomalyTimelineService,
    anomalyDetectorService
  }] = services;
  const [swimlaneData, setSwimlaneData] = (0, _react.useState)();
  const [swimlaneType, setSwimlaneType] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();
  const [perPage, setPerPage] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const chartWidth$ = (0, _react.useMemo)(() => new _rxjs.Subject(), []);
  const selectedJobs$ = (0, _react.useMemo)(() => {
    return (0, _get_jobs_observable.getJobsObservable)(embeddableInput$, anomalyDetectorService, setError).pipe((0, _operators.shareReplay)(1));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const bucketInterval$ = (0, _react.useMemo)(() => {
    return (0, _rxjs.combineLatest)([selectedJobs$, chartWidth$, embeddableInput$.pipe((0, _operators.pluck)('timeRange'))]).pipe((0, _operators.skipWhile)(([jobs, width]) => !Array.isArray(jobs) || !width), (0, _operators.tap)(([,, timeRange]) => {
      anomalyTimelineService.setTimeRange(timeRange);
    }), (0, _operators.map)(([jobs, width]) => anomalyTimelineService.getSwimlaneBucketInterval(jobs, width)), (0, _operators.distinctUntilChanged)((prev, curr) => {
      return prev.asSeconds() === curr.asSeconds();
    }));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const fromPage$ = (0, _react.useMemo)(() => new _rxjs.Subject(), []);
  const perPage$ = (0, _react.useMemo)(() => new _rxjs.Subject(), []);
  const timeBuckets = (0, _react.useMemo)(() => {
    return new _time_buckets.TimeBuckets({
      'histogram:maxBars': uiSettings.get(_public.UI_SETTINGS.HISTOGRAM_MAX_BARS),
      'histogram:barTarget': uiSettings.get(_public.UI_SETTINGS.HISTOGRAM_BAR_TARGET),
      dateFormat: uiSettings.get('dateFormat'),
      'dateFormat:scaled': uiSettings.get('dateFormat:scaled')
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    const subscription = (0, _rxjs.combineLatest)([selectedJobs$, embeddableInput$, bucketInterval$, fromPage$, perPage$.pipe((0, _operators.startWith)(undefined),
    // no need to emit when the initial value has been set
    (0, _operators.distinctUntilChanged)((prev, curr) => prev === undefined && curr === _explorer_constants.SWIM_LANE_DEFAULT_PAGE_SIZE)), refresh.pipe((0, _operators.startWith)(null))]).pipe((0, _operators.tap)(setIsLoading.bind(null, true)), (0, _operators.debounceTime)(FETCH_RESULTS_DEBOUNCE_MS), (0, _operators.tap)(() => {
      renderCallbacks.onLoading();
    }), (0, _operators.switchMap)(([explorerJobs, input, bucketInterval, fromPageInput, perPageFromState]) => {
      if (!explorerJobs) {
        // couldn't load the list of jobs
        return (0, _rxjs.of)(undefined);
      }
      const {
        viewBy,
        swimlaneType: swimlaneTypeInput,
        perPage: perPageInput,
        filters,
        query,
        viewMode
      } = input;
      if (!swimlaneType) {
        setSwimlaneType(swimlaneTypeInput);
      }
      let appliedFilters;
      try {
        if (filters || query) {
          appliedFilters = (0, _process_filters.processFilters)(filters, query, _.CONTROLLED_BY_SWIM_LANE_FILTER);
        }
      } catch (e) {
        // handle query syntax errors
        setError(e);
        return (0, _rxjs.of)(undefined);
      }
      return (0, _rxjs.from)(anomalyTimelineService.loadOverallData(explorerJobs, undefined, bucketInterval)).pipe((0, _operators.switchMap)(overallSwimlaneData => {
        const {
          earliest,
          latest
        } = overallSwimlaneData;
        if (overallSwimlaneData && swimlaneTypeInput === _explorer_constants.SWIMLANE_TYPE.VIEW_BY) {
          var _ref;
          if (perPageFromState === undefined) {
            // set initial pagination from the input or default one
            setPerPage(perPageInput !== null && perPageInput !== void 0 ? perPageInput : _explorer_constants.SWIM_LANE_DEFAULT_PAGE_SIZE);
          }
          if (viewMode === _public2.ViewMode.EDIT && perPageFromState !== perPageInput) {
            // store per page value when the dashboard is in the edit mode
            onInputChange({
              perPage: perPageFromState
            });
          }
          return (0, _rxjs.from)(anomalyTimelineService.loadViewBySwimlane([], {
            earliest,
            latest
          }, explorerJobs, viewBy, (0, _swimlane_container.isViewBySwimLaneData)(swimlaneData) ? swimlaneData.cardinality : _explorer_constants.ANOMALY_SWIM_LANE_HARD_LIMIT, (_ref = perPageFromState !== null && perPageFromState !== void 0 ? perPageFromState : perPageInput) !== null && _ref !== void 0 ? _ref : _explorer_constants.SWIM_LANE_DEFAULT_PAGE_SIZE, fromPageInput, undefined, appliedFilters, bucketInterval)).pipe((0, _operators.map)(viewBySwimlaneData => {
            return {
              ...viewBySwimlaneData,
              earliest,
              latest
            };
          }));
        }
        return (0, _rxjs.of)(overallSwimlaneData);
      }));
    }), (0, _operators.catchError)(e => {
      setError(e.body);
      return (0, _rxjs.of)(undefined);
    })).subscribe(data => {
      if (data !== undefined) {
        setError(null);
        setSwimlaneData(data);
        setIsLoading(false);
      }
    });
    return () => {
      subscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    fromPage$.next(fromPage);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [fromPage]);
  (0, _react.useEffect)(() => {
    if (perPage === undefined) return;
    perPage$.next(perPage);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [perPage]);
  (0, _react.useEffect)(() => {
    chartWidth$.next(chartWidth);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [chartWidth]);
  (0, _react.useEffect)(() => {
    if (error) {
      renderCallbacks.onError(error);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [error]);
  (0, _react.useEffect)(() => {
    if (swimlaneData) {
      renderCallbacks.onRenderComplete();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [swimlaneData]);
  return [swimlaneType, swimlaneData, perPage !== null && perPage !== void 0 ? perPage : _explorer_constants.SWIM_LANE_DEFAULT_PAGE_SIZE, setPerPage, timeBuckets, isLoading, error];
}