"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EmbeddableSwimLaneContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _swimlane_annotation_container = require("../../application/explorer/swimlane_annotation_container");
var _use_embeddable_execution_context = require("../common/use_embeddable_execution_context");
var _swimlane_input_resolver = require("./swimlane_input_resolver");
var _swimlane_container = require("../../application/explorer/swimlane_container");
var _ui_actions = require("../../ui_actions");
var _ = require("..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmbeddableSwimLaneContainer = ({
  id,
  embeddableContext,
  embeddableInput$,
  services,
  refresh,
  onInputChange,
  onOutputChange,
  onRenderComplete,
  onLoading,
  onError
}) => {
  (0, _use_embeddable_execution_context.useEmbeddableExecutionContext)(services[0].executionContext, embeddableInput$, _.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE, id);
  const [chartWidth, setChartWidth] = (0, _react.useState)(0);
  const [fromPage, setFromPage] = (0, _react.useState)(1);
  const [{}, {
    uiActions,
    charts: chartsService
  }] = services;
  const [selectedCells, setSelectedCells] = (0, _react.useState)();
  const [swimlaneType, swimlaneData, perPage, setPerPage, timeBuckets, isLoading, error] = (0, _swimlane_input_resolver.useSwimlaneInputResolver)(embeddableInput$, onInputChange, refresh, services, chartWidth, fromPage, {
    onRenderComplete,
    onError,
    onLoading
  });
  (0, _react.useEffect)(() => {
    onOutputChange({
      perPage,
      fromPage,
      interval: swimlaneData === null || swimlaneData === void 0 ? void 0 : swimlaneData.interval
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [perPage, fromPage, swimlaneData]);
  const onCellsSelection = (0, _react.useCallback)(update => {
    setSelectedCells(update);
    if (update) {
      uiActions.getTrigger(_ui_actions.SWIM_LANE_SELECTION_TRIGGER).exec({
        embeddable: embeddableContext,
        data: update,
        updateCallback: setSelectedCells.bind(null, undefined)
      });
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [swimlaneData, perPage, fromPage, setSelectedCells]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.swimlaneEmbeddable.errorMessage",
        defaultMessage: "Unable to load the ML swim lane data"
      }),
      color: "danger",
      iconType: "warning",
      css: {
        width: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement("p", null, error.message));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        width: 100%;
        padding: 8px;
      `,
    "data-test-subj": "mlAnomalySwimlaneEmbeddableWrapper"
  }, /*#__PURE__*/_react.default.createElement(_swimlane_container.SwimlaneContainer, {
    id: id,
    "data-test-subj": `mlSwimLaneEmbeddable_${embeddableContext.id}`,
    timeBuckets: timeBuckets,
    swimlaneData: swimlaneData,
    swimlaneType: swimlaneType,
    fromPage: fromPage,
    perPage: perPage,
    swimlaneLimit: (0, _swimlane_container.isViewBySwimLaneData)(swimlaneData) ? swimlaneData.cardinality : undefined,
    onResize: setChartWidth,
    selection: selectedCells,
    onCellsSelection: onCellsSelection,
    onPaginationChange: update => {
      if (update.fromPage) {
        setFromPage(update.fromPage);
      }
      if (update.perPage) {
        setFromPage(1);
        setPerPage(update.perPage);
      }
    },
    isLoading: isLoading,
    yAxisWidth: {
      max: _swimlane_annotation_container.Y_AXIS_LABEL_WIDTH
    },
    noDataWarning: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      titleSize: "xxs",
      css: {
        padding: 0
      },
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.swimlaneEmbeddable.noDataFound",
        defaultMessage: "No anomalies found"
      }))
    }),
    chartsService: chartsService
  }));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.EmbeddableSwimLaneContainer = EmbeddableSwimLaneContainer;
var _default = EmbeddableSwimLaneContainer;
exports.default = _default;