"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_ANOMALY_CHARTS_ALLOWED = exports.AnomalyChartsInitializer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _anomaly_explorer_charts_service = require("../../application/services/anomaly_explorer_charts_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ANOMALY_CHARTS_ALLOWED = 48;
exports.MAX_ANOMALY_CHARTS_ALLOWED = MAX_ANOMALY_CHARTS_ALLOWED;
const AnomalyChartsInitializer = ({
  defaultTitle,
  initialInput,
  onCreate,
  onCancel
}) => {
  var _initialInput$maxSeri;
  const [panelTitle, setPanelTitle] = (0, _react.useState)(defaultTitle);
  const [maxSeriesToPlot, setMaxSeriesToPlot] = (0, _react.useState)((_initialInput$maxSeri = initialInput === null || initialInput === void 0 ? void 0 : initialInput.maxSeriesToPlot) !== null && _initialInput$maxSeri !== void 0 ? _initialInput$maxSeri : _anomaly_explorer_charts_service.DEFAULT_MAX_SERIES_TO_PLOT);
  const isPanelTitleValid = panelTitle.length > 0;
  const isFormValid = isPanelTitleValid && maxSeriesToPlot > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    initialFocus: "[name=panelTitle]",
    onClose: onCancel,
    "data-test-subj": 'mlAnomalyChartsEmbeddableInitializer'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyChartsEmbeddable.setupModal.title",
    defaultMessage: "Anomaly explorer charts configuration"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyChartsEmbeddable.panelTitleLabel",
      defaultMessage: "Panel title"
    }),
    isInvalid: !isPanelTitleValid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "panelTitleInput",
    id: "panelTitle",
    name: "panelTitle",
    value: panelTitle,
    onChange: e => setPanelTitle(e.target.value),
    isInvalid: !isPanelTitleValid
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyChartsEmbeddable.maxSeriesToPlotLabel",
      defaultMessage: "Maximum number of series to plot"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "mlAnomalyChartsInitializerMaxSeries",
    id: "selectMaxSeriesToPlot",
    name: "selectMaxSeriesToPlot",
    value: maxSeriesToPlot,
    onChange: e => setMaxSeriesToPlot(parseInt(e.target.value, 10)),
    min: 0,
    max: MAX_ANOMALY_CHARTS_ALLOWED
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "mlAnomalyChartsInitializerCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyChartsEmbeddable.setupModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlAnomalyChartsInitializerConfirmButton",
    isDisabled: !isFormValid,
    onClick: onCreate.bind(null, {
      panelTitle,
      maxSeriesToPlot
    }),
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyChartsEmbeddable.setupModal.confirmButtonLabel",
    defaultMessage: "Confirm configurations"
  }))));
};
exports.AnomalyChartsInitializer = AnomalyChartsInitializer;