"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAnomalySwimLaneCasesAttachment = registerAnomalySwimLaneCasesAttachment;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _cases = require("../../common/constants/cases");
var _embeddables = require("../embeddables");
var _app = require("../../common/constants/app");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function registerAnomalySwimLaneCasesAttachment(cases, coreStart, pluginStart) {
  const EmbeddableComponent = (0, _embeddables.getEmbeddableComponent)(_cases.CASE_ATTACHMENT_TYPE_ID_ANOMALY_SWIMLANE, coreStart, pluginStart);
  cases.attachmentFramework.registerPersistableState({
    id: _cases.CASE_ATTACHMENT_TYPE_ID_ANOMALY_SWIMLANE,
    icon: _app.PLUGIN_ICON,
    displayName: _i18n.i18n.translate('xpack.ml.cases.anomalySwimLane.displayName', {
      defaultMessage: 'Anomaly swim lane'
    }),
    getAttachmentViewObject: () => ({
      event: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.cases.anomalySwimLane.embeddableAddedEvent",
        defaultMessage: "added anomaly swim lane"
      }),
      timelineAvatar: _app.PLUGIN_ICON,
      children: /*#__PURE__*/_react.default.lazy(async () => {
        const {
          initComponent
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_swim_lane_attachment')));
        return {
          default: initComponent(pluginStart.fieldFormats, EmbeddableComponent)
        };
      })
    })
  });
}