"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFocusData = getFocusData;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _ml_api_service = require("../../services/ml_api_service");
var _search = require("../../../../common/constants/search");
var _timeseries_search_service = require("../timeseries_search_service");
var _results_service = require("../../services/results_service");
var _timeseriesexplorer_constants = require("../timeseriesexplorer_constants");
var _timeseriesexplorer_utils = require("./timeseriesexplorer_utils");
var _forecast_service = require("../../services/forecast_service");
var _job_utils = require("../../../../common/util/job_utils");
var _anomaly_utils = require("../../../../common/util/anomaly_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFocusData(criteriaFields, detectorIndex, focusAggregationInterval, forecastId, modelPlotEnabled, nonBlankEntities, searchBounds, selectedJob, functionDescription) {
  const esFunctionToPlotIfMetric = functionDescription !== undefined ? _anomaly_utils.aggregationTypeTransform.toES(functionDescription) : functionDescription;
  return (0, _rxjs.forkJoin)([
  // Query 1 - load metric data across selected time range.
  _timeseries_search_service.mlTimeSeriesSearchService.getMetricData(selectedJob, detectorIndex, nonBlankEntities, searchBounds.min.valueOf(), searchBounds.max.valueOf(), focusAggregationInterval.asMilliseconds(), esFunctionToPlotIfMetric),
  // Query 2 - load all the records across selected time range for the chart anomaly markers.
  _ml_api_service.ml.results.getAnomalyRecords$([selectedJob.job_id], criteriaFields, 0, searchBounds.min.valueOf(), searchBounds.max.valueOf(), focusAggregationInterval.expression, functionDescription),
  // Query 3 - load any scheduled events for the selected job.
  _results_service.mlResultsService.getScheduledEventsByBucket([selectedJob.job_id], searchBounds.min.valueOf(), searchBounds.max.valueOf(), focusAggregationInterval.asMilliseconds(), 1, _timeseriesexplorer_constants.MAX_SCHEDULED_EVENTS),
  // Query 4 - load any annotations for the selected job.
  _ml_api_service.ml.annotations.getAnnotations$({
    jobIds: [selectedJob.job_id],
    earliestMs: searchBounds.min.valueOf(),
    latestMs: searchBounds.max.valueOf(),
    maxAnnotations: _search.ANNOTATIONS_TABLE_DEFAULT_QUERY_SIZE,
    detectorIndex,
    entities: nonBlankEntities
  }).pipe((0, _operators.catchError)(resp => (0, _rxjs.of)({
    annotations: {},
    totalCount: 0,
    error: (0, _mlErrorUtils.extractErrorMessage)(resp),
    success: false
  }))),
  // Plus query for forecast data if there is a forecastId stored in the appState.
  forecastId !== undefined ? (() => {
    let aggType;
    const detector = selectedJob.analysis_config.detectors[detectorIndex];
    const esAgg = (0, _job_utils.mlFunctionToESAggregation)(detector.function);
    if (!modelPlotEnabled && (esAgg === 'sum' || esAgg === 'count')) {
      aggType = {
        avg: 'sum',
        max: 'sum',
        min: 'sum'
      };
    }
    return _forecast_service.mlForecastService.getForecastData(selectedJob, detectorIndex, forecastId, nonBlankEntities, searchBounds.min.valueOf(), searchBounds.max.valueOf(), focusAggregationInterval.asMilliseconds(), aggType);
  })() : (0, _rxjs.of)(null)]).pipe((0, _operators.map)(([metricData, recordsForCriteria, scheduledEventsByBucket, annotations, forecastData]) => {
    // Sort in descending time order before storing in scope.
    const anomalyRecords = recordsForCriteria.records.sort((a, b) => a[_timeseriesexplorer_constants.TIME_FIELD_NAME] - b[_timeseriesexplorer_constants.TIME_FIELD_NAME]).reverse();
    const scheduledEvents = scheduledEventsByBucket.events[selectedJob.job_id];
    let focusChartData = (0, _timeseriesexplorer_utils.processMetricPlotResults)(metricData.results, modelPlotEnabled);
    // Tell the results container directives to render the focus chart.
    focusChartData = (0, _timeseriesexplorer_utils.processDataForFocusAnomalies)(focusChartData, anomalyRecords, focusAggregationInterval, modelPlotEnabled, functionDescription);
    focusChartData = (0, _timeseriesexplorer_utils.processScheduledEventsForChart)(focusChartData, scheduledEvents, focusAggregationInterval);
    const refreshFocusData = {
      scheduledEvents,
      anomalyRecords,
      focusChartData
    };
    if (annotations) {
      if (annotations.error !== undefined) {
        refreshFocusData.focusAnnotationError = annotations.error;
        refreshFocusData.focusAnnotationData = [];
      } else {
        var _annotations$annotati;
        refreshFocusData.focusAnnotationData = ((_annotations$annotati = annotations.annotations[selectedJob.job_id]) !== null && _annotations$annotati !== void 0 ? _annotations$annotati : []).sort((a, b) => {
          return a.timestamp - b.timestamp;
        }).map((d, i) => {
          d.key = (i + 1).toString();
          return d;
        });
      }
    }
    if (forecastData) {
      refreshFocusData.focusForecastData = (0, _timeseriesexplorer_utils.processForecastResults)(forecastData.results);
      refreshFocusData.showForecastCheckbox = refreshFocusData.focusForecastData.length > 0;
    }
    return refreshFocusData;
  }));
}