"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlotByFunctionControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _job_service = require("../../../services/job_service");
var _get_function_description = require("../../get_function_description");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _aggregation_types = require("../../../../../common/constants/aggregation_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const plotByFunctionOptions = [{
  value: 'mean',
  text: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.plotByAvgOptionLabel', {
    defaultMessage: 'mean'
  })
}, {
  value: 'min',
  text: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.plotByMinOptionLabel', {
    defaultMessage: 'min'
  })
}, {
  value: 'max',
  text: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.plotByMaxOptionLabel', {
    defaultMessage: 'max'
  })
}];
const PlotByFunctionControls = ({
  functionDescription,
  setFunctionDescription,
  selectedDetectorIndex,
  selectedJobId,
  selectedEntities,
  entityControlsCount
}) => {
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const getFunctionDescriptionToPlot = (0, _react.useCallback)(async (_selectedDetectorIndex, _selectedEntities, _selectedJobId, _selectedJob) => {
    const functionToPlot = await (0, _get_function_description.getFunctionDescription)({
      selectedDetectorIndex: _selectedDetectorIndex,
      selectedEntities: _selectedEntities,
      selectedJobId: _selectedJobId,
      selectedJob: _selectedJob
    }, toastNotificationService);
    setFunctionDescription(functionToPlot);
  }, [setFunctionDescription, toastNotificationService]);
  (0, _react.useEffect)(() => {
    if (functionDescription !== undefined) {
      return;
    }
    const selectedJob = _job_service.mlJobService.getJob(selectedJobId);
    // if no controls, it's okay to fetch
    // if there are series controls, only fetch if user has selected something
    const validEntities = entityControlsCount === 0 || entityControlsCount > 0 && selectedEntities !== undefined;
    if (validEntities && functionDescription === undefined && (0, _get_function_description.isMetricDetector)(selectedJob, selectedDetectorIndex)) {
      const detector = selectedJob.analysis_config.detectors[selectedDetectorIndex];
      if ((detector === null || detector === void 0 ? void 0 : detector.function) === _aggregation_types.ML_JOB_AGGREGATION.METRIC) {
        getFunctionDescriptionToPlot(selectedDetectorIndex, selectedEntities, selectedJobId, selectedJob);
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [setFunctionDescription, selectedDetectorIndex, selectedEntities, selectedJobId, functionDescription, entityControlsCount]);
  if (functionDescription === undefined) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.metricPlotByOption', {
      defaultMessage: 'Function'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: plotByFunctionOptions,
    value: functionDescription,
    onChange: e => setFunctionDescription(e.target.value),
    "aria-label": _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.metricPlotByOptionLabel', {
      defaultMessage: 'Pick function to plot by (min, max, or average) if metric function'
    })
  })));
};
exports.PlotByFunctionControls = PlotByFunctionControls;