"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Modal = Modal;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _message_call_out = require("../../../components/message_call_out");
var _forecasts_list = require("./forecasts_list");
var _run_controls = require("./run_controls");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Renders the modal dialog which allows the user to run and view time series forecasts.
 */

function Modal(props) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: props.close,
    maxWidth: 860,
    "data-test-subj": "mlModalForecast"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.forecastingModal.forecastingTitle",
    defaultMessage: "Forecasting"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, props.messages.map((message, i) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: i
  }, /*#__PURE__*/_react.default.createElement(_message_call_out.MessageCallOut, message), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))), props.forecasts.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_forecasts_list.ForecastsList, {
    forecasts: props.forecasts,
    viewForecast: props.viewForecast
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_run_controls.RunControls, props)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: props.close,
    size: "s",
    "data-test-subj": "mlModalForecastButtonClose"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.forecastingModal.closeButtonLabel",
    defaultMessage: "Close"
  }))));
}
Modal.propType = {
  job: _propTypes.default.object,
  forecasts: _propTypes.default.array,
  close: _propTypes.default.func.isRequired,
  viewForecast: _propTypes.default.func.isRequired,
  runForecast: _propTypes.default.func.isRequired,
  newForecastDuration: _propTypes.default.string,
  isNewForecastDurationValid: _propTypes.default.bool,
  newForecastDurationErrors: _propTypes.default.array,
  onNewForecastDurationChange: _propTypes.default.func.isRequired,
  isForecastRequested: _propTypes.default.bool,
  forecastProgress: _propTypes.default.number,
  jobOpeningState: _propTypes.default.number,
  jobClosingState: _propTypes.default.number,
  messages: _propTypes.default.array
};