"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditDescriptionPopover = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React popover for editing the description of a filter list.
 */

class EditDescriptionPopover extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onChange", e => {
      this.setState({
        value: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      if (this.state.isPopoverOpen === false) {
        this.setState({
          isPopoverOpen: !this.state.isPopoverOpen,
          value: this.props.description
        });
      } else {
        this.closePopover();
      }
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      if (this.state.isPopoverOpen === true) {
        this.setState({
          isPopoverOpen: false
        });
        this.props.updateDescription(this.state.value);
      }
    });
    this.state = {
      isPopoverOpen: false,
      value: props.description
    };
  }
  render() {
    const {
      isPopoverOpen,
      value
    } = this.state;
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      color: "primary",
      onClick: this.onButtonClick,
      iconType: "pencil",
      "aria-label": _i18n.i18n.translate('xpack.ml.settings.filterLists.editDescriptionPopover.editDescriptionAriaLabel', {
        defaultMessage: 'Edit description'
      }),
      isDisabled: this.props.canCreateFilter === false,
      "data-test-subj": "mlFilterListEditDescriptionButton"
    });
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "filter_list_description_popover",
      ownFocus: true,
      button: button,
      isOpen: isPopoverOpen,
      closePopover: this.closePopover,
      initialFocus: "#filter_list_edit_description_row"
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '300px'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "filter_list_edit_description_row",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.settings.filterLists.editDescriptionPopover.filterListDescriptionAriaLabel",
        defaultMessage: "Filter list description"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: "filter_list_description",
      value: value,
      onChange: this.onChange,
      "data-test-subj": 'mlFilterListDescriptionInput'
    }))))));
  }
}
exports.EditDescriptionPopover = EditDescriptionPopover;
(0, _defineProperty2.default)(EditDescriptionPopover, "displayName", 'EditDescriptionPopover');
(0, _defineProperty2.default)(EditDescriptionPopover, "propTypes", {
  description: _propTypes.default.string,
  updateDescription: _propTypes.default.func.isRequired,
  canCreateFilter: _propTypes.default.bool.isRequired
});