"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateTempId = generateTempId;
exports.getCalendarSettingsData = getCalendarSettingsData;
exports.validateCalendarId = validateCalendarId;
var _ml_api_service = require("../../../services/ml_api_service");
var _job_utils = require("../../../../../common/util/job_utils");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getJobIds() {
  return new Promise((resolve, reject) => {
    _ml_api_service.ml.jobs.jobsSummary().then(resp => {
      resolve(resp.map(job => job.id));
    }).catch(err => {
      const errorMessage = _i18n.i18n.translate('xpack.ml.calendarsEdit.errorWithFetchingJobSummariesErrorMessage', {
        defaultMessage: 'Error fetching job summaries: {err}',
        values: {
          err
        }
      });
      console.log(errorMessage);
      reject(errorMessage);
    });
  });
}
function getGroupIds() {
  return new Promise((resolve, reject) => {
    _ml_api_service.ml.jobs.groups().then(resp => {
      resolve(resp.map(group => group.id));
    }).catch(err => {
      const errorMessage = _i18n.i18n.translate('xpack.ml.calendarsEdit.errorWithLoadingGroupsErrorMessage', {
        defaultMessage: 'Error loading groups: {err}',
        values: {
          err
        }
      });
      console.log(errorMessage);
      reject(errorMessage);
    });
  });
}
function getCalendars() {
  return new Promise((resolve, reject) => {
    _ml_api_service.ml.calendars().then(resp => {
      resolve(resp);
    }).catch(err => {
      const errorMessage = _i18n.i18n.translate('xpack.ml.calendarsEdit.errorWithLoadingCalendarsErrorMessage', {
        defaultMessage: 'Error loading calendars: {err}',
        values: {
          err
        }
      });
      console.log(errorMessage);
      reject(errorMessage);
    });
  });
}
function getCalendarSettingsData() {
  return new Promise(async (resolve, reject) => {
    try {
      const [jobIds, groupIds, calendars] = await Promise.all([getJobIds(), getGroupIds(), getCalendars()]);
      resolve({
        jobIds,
        groupIds,
        calendars
      });
    } catch (error) {
      console.log(error);
      reject(error);
    }
  });
}
function validateCalendarId(calendarId) {
  let valid = true;
  if (calendarId === '' || calendarId === undefined) {
    valid = false;
  } else if ((0, _job_utils.isJobIdValid)(calendarId) === false) {
    valid = false;
  }
  return valid;
}
function generateTempId() {
  return Math.random().toString(36).substr(2, 9);
}