"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterEvents = filterEvents;
exports.parseICSFile = parseICSFile;
exports.readFile = readFile;
var _icalendar = _interopRequireDefault(require("icalendar"));
var _moment = _interopRequireDefault(require("moment"));
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createEvents(ical) {
  const events = ical.events();
  const mlEvents = [];
  events.forEach(e => {
    if (e.element === 'VEVENT') {
      const description = e.properties.SUMMARY;
      const start = e.properties.DTSTART;
      const end = e.properties.DTEND;
      const recurring = e.properties.RRULE !== undefined;
      if (description && start && end && description.length && start.length && end.length) {
        // Temp reference to unsaved events to allow removal from table
        const tempId = (0, _utils.generateTempId)();
        mlEvents.push({
          event_id: tempId,
          description: description[0].value,
          start_time: start[0].value.valueOf(),
          end_time: end[0].value.valueOf(),
          asterisk: recurring
        });
      }
    }
  });
  return mlEvents;
}
function filterEvents(events) {
  const now = (0, _moment.default)().valueOf();
  return events.filter(e => e.start_time > now);
}
function parseICSFile(data) {
  // force a new line char on the end of the data
  // icalendar must split on new lines and so parsing fails
  // if there isn't at least one new line at the end.
  const cal = _icalendar.default.parse_calendar(data + '\n');
  return createEvents(cal);
}
function readFile(file) {
  return new Promise((resolve, reject) => {
    if (file && file.size) {
      const reader = new FileReader();
      reader.readAsText(file);
      reader.onload = (() => {
        return () => {
          const data = reader.result;
          if (data === '') {
            reject();
          } else {
            resolve({
              data
            });
          }
        };
      })(file);
    } else {
      reject();
    }
  });
}