"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsTable = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _time_format = require("../../../../../../common/constants/time_format");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DeleteButton({
  onClick,
  testSubj,
  disabled
}) {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "danger",
    onClick: onClick,
    isDisabled: disabled,
    "data-test-subj": testSubj
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.eventsTable.deleteButtonLabel",
    defaultMessage: "Delete"
  })));
}
const EventsTable = ({
  canCreateCalendar,
  canDeleteCalendar,
  eventsList,
  onDeleteClick,
  showSearchBar,
  showImportModal,
  showNewEventModal,
  loading,
  saving
}) => {
  const sorting = {
    sort: {
      field: 'description',
      direction: 'asc'
    }
  };
  const pagination = {
    initialPageSize: 5,
    pageSizeOptions: [5, 10]
  };
  const columns = [{
    field: 'description',
    name: _i18n.i18n.translate('xpack.ml.calendarsEdit.eventsTable.descriptionColumnName', {
      defaultMessage: 'Description'
    }),
    sortable: true,
    truncateText: true,
    scope: 'row'
  }, {
    field: 'start_time',
    name: _i18n.i18n.translate('xpack.ml.calendarsEdit.eventsTable.startColumnName', {
      defaultMessage: 'Start'
    }),
    sortable: true,
    render: timeMs => {
      const time = (0, _moment.default)(timeMs);
      return time.format(_time_format.TIME_FORMAT);
    }
  }, {
    field: 'end_time',
    name: _i18n.i18n.translate('xpack.ml.calendarsEdit.eventsTable.endColumnName', {
      defaultMessage: 'End'
    }),
    sortable: true,
    render: timeMs => {
      const time = (0, _moment.default)(timeMs);
      return time.format(_time_format.TIME_FORMAT);
    }
  }, {
    field: '',
    name: '',
    render: event => /*#__PURE__*/_react.default.createElement(DeleteButton, {
      testSubj: "mlCalendarEventDeleteButton",
      disabled: canDeleteCalendar === false || saving === true || loading === true,
      onClick: () => {
        onDeleteClick(event.event_id);
      }
    })
  }];
  const search = {
    toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: canCreateCalendar === false || saving === true || loading === true,
      key: "ml_new_event",
      "data-test-subj": "mlCalendarNewEventButton",
      size: "s",
      iconType: "plusInCircle",
      onClick: showNewEventModal
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.eventsTable.newEventButtonLabel",
      defaultMessage: "New event"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: canCreateCalendar === false || saving === true || loading === true,
      key: "ml_import_event",
      "data-test-subj": "mlCalendarImportEventsButton",
      size: "s",
      iconType: "importAction",
      onClick: showImportModal
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.eventsTable.importEventsButtonLabel",
      defaultMessage: "Import events"
    }))],
    box: {
      incremental: true
    },
    filters: []
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: eventsList,
    itemId: "event_id",
    columns: columns,
    pagination: pagination,
    sorting: sorting,
    search: showSearchBar ? search : undefined,
    "data-test-subj": "mlCalendarEventsTable",
    rowProps: item => ({
      'data-test-subj': `mlCalendarEventListRow row-${item.description}`
    })
  }));
};
exports.EventsTable = EventsTable;
EventsTable.propTypes = {
  canCreateCalendar: _propTypes.default.bool,
  canDeleteCalendar: _propTypes.default.bool,
  eventsList: _propTypes.default.array.isRequired,
  onDeleteClick: _propTypes.default.func.isRequired,
  showImportModal: _propTypes.default.func,
  showNewEventModal: _propTypes.default.func,
  showSearchBar: _propTypes.default.bool,
  loading: _propTypes.default.bool,
  saving: _propTypes.default.bool
};
EventsTable.defaultProps = {
  showSearchBar: false,
  canCreateCalendar: true,
  canDeleteCalendar: true
};