"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newJobCapsServiceAnalytics = void 0;
exports.removeNestedFieldChildren = removeNestedFieldChildren;
var _fieldTypes = require("@kbn/field-types");
var _new_job_capabilities = require("./new_job_capabilities");
var _ml_api_service = require("../ml_api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Keep top nested field and remove all <nested_field>.* fields
function removeNestedFieldChildren(resp, indexPatternTitle) {
  const results = resp[indexPatternTitle];
  const fields = [];
  const nestedFields = {};
  if (results !== undefined) {
    results.fields.forEach(field => {
      if (field.type === _fieldTypes.ES_FIELD_TYPES.NESTED && nestedFields[field.name] === undefined) {
        nestedFields[field.name] = true;
        fields.push(field);
      }
    });
    if (Object.keys(nestedFields).length > 0) {
      results.fields.forEach(field => {
        if (field.type !== _fieldTypes.ES_FIELD_TYPES.NESTED) {
          const fieldNameParts = field.name.split('.');
          const rootOfField = fieldNameParts.shift();
          if (rootOfField && nestedFields[rootOfField] === undefined) {
            fields.push(field);
          }
        }
      });
    } else {
      fields.push(...results.fields);
    }
  }
  return fields;
}
class NewJobCapsServiceAnalytics extends _new_job_capabilities.NewJobCapabilitiesServiceBase {
  async initializeFromDataVIew(dataView) {
    try {
      const resp = await _ml_api_service.ml.dataFrameAnalytics.newJobCapsAnalytics(dataView.getIndexPattern(), dataView.type === 'rollup');
      const allFields = removeNestedFieldChildren(resp, dataView.getIndexPattern());
      const {
        fieldsPreferringKeyword
      } = (0, _new_job_capabilities.processTextAndKeywordFields)(allFields);

      // set the main fields list to contain fields which have been filtered to prefer
      // keyword fields over text fields.
      // e.g. if foo.keyword and foo exist, don't add foo to the list.
      this._fields = fieldsPreferringKeyword;
      this.removeCounterFields();
    } catch (error) {
      console.error('Unable to load analytics index fields', error); // eslint-disable-line no-console
    }
  }
}

const newJobCapsServiceAnalytics = new NewJobCapsServiceAnalytics();
exports.newJobCapsServiceAnalytics = newJobCapsServiceAnalytics;