"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DATA_FRAME_ANALYTICS = exports.ANOMALY_DETECTOR = void 0;
exports.loadNewJobCapabilities = loadNewJobCapabilities;
var _index_utils = require("../../util/index_utils");
var _new_job_capabilities_service_analytics = require("./new_job_capabilities_service_analytics");
var _new_job_capabilities_service = require("./new_job_capabilities_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANOMALY_DETECTOR = 'anomaly-detector';
exports.ANOMALY_DETECTOR = ANOMALY_DETECTOR;
const DATA_FRAME_ANALYTICS = 'data-frame-analytics';

// called in the routing resolve block to initialize the NewJobCapabilites
// service for the corresponding job type with the currently selected data view
exports.DATA_FRAME_ANALYTICS = DATA_FRAME_ANALYTICS;
function loadNewJobCapabilities(dataViewId, savedSearchId, dataViewContract, jobType) {
  return new Promise(async (resolve, reject) => {
    try {
      const serviceToUse = jobType === ANOMALY_DETECTOR ? _new_job_capabilities_service.newJobCapsService : _new_job_capabilities_service_analytics.newJobCapsServiceAnalytics;
      if (dataViewId !== undefined) {
        // index pattern is being used
        const dataView = await dataViewContract.get(dataViewId);
        await serviceToUse.initializeFromDataVIew(dataView);
        resolve(serviceToUse.newJobCaps);
      } else if (savedSearchId !== undefined) {
        // saved search is being used
        // load the data view from the saved search
        const {
          dataView
        } = await (0, _index_utils.getDataViewAndSavedSearch)(savedSearchId);
        if (dataView === null) {
          // eslint-disable-next-line no-console
          console.error('Cannot retrieve data view from saved search');
          reject();
          return;
        }
        await serviceToUse.initializeFromDataVIew(dataView);
        resolve(serviceToUse.newJobCaps);
      } else {
        reject();
      }
    } catch (error) {
      reject(error);
    }
  });
}