"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jsonSchemaProvider = jsonSchemaProvider;
var _lodash = require("lodash");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function jsonSchemaProvider(httpService) {
  const apiBasePath = (0, _.basePath)();
  return {
    getSchemaDefinition(params) {
      return httpService.http({
        path: `${apiBasePath}/json_schema`,
        method: 'GET',
        query: (0, _lodash.omitBy)(params, v => !(0, _mlIsDefined.isDefined)(v))
      });
    }
  };
}