"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobsApiProvider = void 0;
exports.useJobsApiService = useJobsApiService;
var _react = require("react");
var _kibana = require("../../contexts/kibana");
var _app = require("../../../../common/constants/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const jobsApiProvider = httpService => ({
  jobsSummary(jobIds) {
    const body = JSON.stringify({
      jobIds
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/jobs_summary`,
      method: 'POST',
      body
    });
  },
  jobIdsWithGeo() {
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/jobs_with_geo`,
      method: 'GET'
    });
  },
  jobsWithTimerange(dateFormatTz) {
    const body = JSON.stringify({
      dateFormatTz
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/jobs_with_time_range`,
      method: 'POST',
      body
    });
  },
  jobForCloning(jobId) {
    const body = JSON.stringify({
      jobId
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/job_for_cloning`,
      method: 'POST',
      body
    });
  },
  jobs(jobIds) {
    const body = JSON.stringify({
      jobIds
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/jobs`,
      method: 'POST',
      body
    });
  },
  groups() {
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/groups`,
      method: 'GET'
    });
  },
  updateGroups(updatedJobs) {
    const body = JSON.stringify({
      jobs: updatedJobs
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/update_groups`,
      method: 'POST',
      body
    });
  },
  forceStartDatafeeds(datafeedIds, start, end) {
    const body = JSON.stringify({
      datafeedIds,
      start,
      end
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/force_start_datafeeds`,
      method: 'POST',
      body
    });
  },
  stopDatafeeds(datafeedIds) {
    const body = JSON.stringify({
      datafeedIds
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/stop_datafeeds`,
      method: 'POST',
      body
    });
  },
  deleteJobs(jobIds, deleteUserAnnotations) {
    const body = JSON.stringify({
      jobIds,
      deleteUserAnnotations
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/delete_jobs`,
      method: 'POST',
      body
    });
  },
  closeJobs(jobIds) {
    const body = JSON.stringify({
      jobIds
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/close_jobs`,
      method: 'POST',
      body
    });
  },
  resetJobs(jobIds, deleteUserAnnotations) {
    const body = JSON.stringify({
      jobIds,
      deleteUserAnnotations
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/reset_jobs`,
      method: 'POST',
      body
    });
  },
  forceStopAndCloseJob(jobId) {
    const body = JSON.stringify({
      jobId
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/force_stop_and_close_job`,
      method: 'POST',
      body
    });
  },
  jobAuditMessages({
    jobId,
    from,
    start,
    end
  }) {
    const jobIdString = jobId !== undefined ? `/${jobId}` : '';
    const query = {
      ...(from !== undefined ? {
        from
      } : {}),
      ...(start !== undefined && end !== undefined ? {
        start,
        end
      } : {})
    };
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/job_audit_messages/messages${jobIdString}`,
      method: 'GET',
      query
    });
  },
  clearJobAuditMessages(jobId, notificationIndices) {
    const body = JSON.stringify({
      jobId,
      notificationIndices
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/job_audit_messages/clear_messages`,
      method: 'PUT',
      body
    });
  },
  blockingJobTasks() {
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/blocking_jobs_tasks`,
      method: 'GET'
    });
  },
  jobsExist(jobIds, allSpaces = false) {
    const body = JSON.stringify({
      jobIds,
      allSpaces
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/jobs_exist`,
      method: 'POST',
      body
    });
  },
  jobsExist$(jobIds, allSpaces = false) {
    const body = JSON.stringify({
      jobIds,
      allSpaces
    });
    return httpService.http$({
      path: `${_app.ML_BASE_PATH}/jobs/jobs_exist`,
      method: 'POST',
      body
    });
  },
  newJobCaps(indexPatternTitle, isRollup = false) {
    const query = isRollup === true ? {
      rollup: true
    } : {};
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/new_job_caps/${indexPatternTitle}`,
      method: 'GET',
      query
    });
  },
  newJobLineChart(indexPatternTitle, timeField, start, end, intervalMs, query, aggFieldNamePairs, splitFieldName, splitFieldValue, runtimeMappings, indicesOptions) {
    const body = JSON.stringify({
      indexPatternTitle,
      timeField,
      start,
      end,
      intervalMs,
      query,
      aggFieldNamePairs,
      splitFieldName,
      splitFieldValue,
      runtimeMappings,
      indicesOptions
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/new_job_line_chart`,
      method: 'POST',
      body
    });
  },
  newJobPopulationsChart(indexPatternTitle, timeField, start, end, intervalMs, query, aggFieldNamePairs, splitFieldName, runtimeMappings, indicesOptions) {
    const body = JSON.stringify({
      indexPatternTitle,
      timeField,
      start,
      end,
      intervalMs,
      query,
      aggFieldNamePairs,
      splitFieldName,
      runtimeMappings,
      indicesOptions
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/new_job_population_chart`,
      method: 'POST',
      body
    });
  },
  getAllJobAndGroupIds() {
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/all_jobs_and_group_ids`,
      method: 'GET'
    });
  },
  getLookBackProgress(jobId, start, end) {
    const body = JSON.stringify({
      jobId,
      start,
      end
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/look_back_progress`,
      method: 'POST',
      body
    });
  },
  categorizationFieldExamples(indexPatternTitle, query, size, field, timeField, start, end, analyzer, runtimeMappings, indicesOptions) {
    const body = JSON.stringify({
      indexPatternTitle,
      query,
      size,
      field,
      timeField,
      start,
      end,
      analyzer,
      runtimeMappings,
      indicesOptions
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/categorization_field_examples`,
      method: 'POST',
      body
    });
  },
  topCategories(jobId, count) {
    const body = JSON.stringify({
      jobId,
      count
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/top_categories`,
      method: 'POST',
      body
    });
  },
  revertModelSnapshot(jobId, snapshotId, replay, end, calendarEvents) {
    const body = JSON.stringify({
      jobId,
      snapshotId,
      replay,
      end,
      calendarEvents
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/revert_model_snapshot`,
      method: 'POST',
      body
    });
  },
  datafeedPreview(datafeedId, job, datafeed) {
    const body = JSON.stringify({
      datafeedId,
      job,
      datafeed
    });
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/datafeed_preview`,
      method: 'POST',
      body
    });
  },
  bulkCreateJobs(jobs) {
    const body = JSON.stringify(jobs);
    return httpService.http({
      path: `${_app.ML_BASE_PATH}/jobs/bulk_create`,
      method: 'POST',
      body
    });
  }
});
exports.jobsApiProvider = jobsApiProvider;
/**
 * Hooks for accessing {@link JobsApiService} in React components.
 */
function useJobsApiService() {
  const {
    services: {
      mlServices: {
        httpService
      }
    }
  } = (0, _kibana.useMlKibana)();
  return (0, _react.useMemo)(() => jobsApiProvider(httpService), [httpService]);
}