"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filtersApiProvider = void 0;
exports.useFiltersApiService = useFiltersApiService;
var _react = require("react");
var _kibana = require("../../contexts/kibana");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Service for querying filters, which hold lists of entities,
// for example a list of known safe URL domains.

const filtersApiProvider = httpService => ({
  filters(obj) {
    const filterId = obj && obj.filterId ? `/${obj.filterId}` : '';
    return httpService.http({
      path: `${(0, _.basePath)()}/filters${filterId}`,
      method: 'GET'
    });
  },
  filtersStats() {
    return httpService.http({
      path: `${(0, _.basePath)()}/filters/_stats`,
      method: 'GET'
    });
  },
  addFilter(filterId, description, items) {
    const body = JSON.stringify({
      filterId,
      description,
      items
    });
    return httpService.http({
      path: `${(0, _.basePath)()}/filters`,
      method: 'PUT',
      body
    });
  },
  updateFilter(filterId, description, addItems, removeItems) {
    const body = JSON.stringify({
      ...(description !== undefined ? {
        description
      } : {}),
      ...(addItems !== undefined ? {
        addItems
      } : {}),
      ...(removeItems !== undefined ? {
        removeItems
      } : {})
    });
    return httpService.http({
      path: `${(0, _.basePath)()}/filters/${filterId}`,
      method: 'PUT',
      body
    });
  },
  deleteFilter(filterId) {
    return httpService.http({
      path: `${(0, _.basePath)()}/filters/${filterId}`,
      method: 'DELETE'
    });
  }
});
exports.filtersApiProvider = filtersApiProvider;
/**
 * Hooks for accessing {@link FiltersApiService} in React components.
 */
function useFiltersApiService() {
  const {
    services: {
      mlServices: {
        httpService
      }
    }
  } = (0, _kibana.useMlKibana)();
  return (0, _react.useMemo)(() => filtersApiProvider(httpService), [httpService]);
}