"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.annotationsApiProvider = void 0;
exports.useAnnotationsApiService = useAnnotationsApiService;
var _react = require("react");
var _kibana = require("../../contexts/kibana");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const annotationsApiProvider = httpService => ({
  getAnnotations$(obj) {
    const body = JSON.stringify(obj);
    return httpService.http$({
      path: `${(0, _.basePath)()}/annotations`,
      method: 'POST',
      body
    });
  },
  getAnnotations(obj) {
    const body = JSON.stringify(obj);
    return httpService.http({
      path: `${(0, _.basePath)()}/annotations`,
      method: 'POST',
      body
    });
  },
  indexAnnotation(obj) {
    const body = JSON.stringify(obj);
    return httpService.http({
      path: `${(0, _.basePath)()}/annotations/index`,
      method: 'PUT',
      body
    });
  },
  deleteAnnotation(id) {
    return httpService.http({
      path: `${(0, _.basePath)()}/annotations/delete/${id}`,
      method: 'DELETE'
    });
  }
});
exports.annotationsApiProvider = annotationsApiProvider;
/**
 * Hooks for accessing {@link AnnotationsApiService} in React components.
 */
function useAnnotationsApiService() {
  const {
    services: {
      mlServices: {
        httpService
      }
    }
  } = (0, _kibana.useMlKibana)();
  return (0, _react.useMemo)(() => annotationsApiProvider(httpService), [httpService]);
}