"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardServiceProvider = dashboardServiceProvider;
exports.useDashboardService = useDashboardService;
var _react = require("react");
var _public = require("@kbn/embeddable-plugin/public");
var _kibana = require("../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function dashboardServiceProvider(savedObjectClient, dashboardLocator) {
  return {
    /**
     * Fetches dashboards
     */
    async fetchDashboards(query) {
      return await savedObjectClient.find({
        type: 'dashboard',
        perPage: 1000,
        search: query ? `${query}*` : '',
        searchFields: ['title^3', 'description']
      });
    },
    /**
     * Generates dashboard url with edit mode
     */
    async getDashboardEditUrl(dashboardId) {
      return await dashboardLocator.getUrl({
        dashboardId,
        viewMode: _public.ViewMode.EDIT,
        useHash: false
      });
    }
  };
}

/**
 * Hook to use {@link DashboardService} in react components
 */
function useDashboardService() {
  const {
    services: {
      savedObjects: {
        client: savedObjectClient
      },
      dashboard: {
        locator: dashboardLocator
      }
    }
  } = (0, _kibana.useMlKibana)();
  return (0, _react.useMemo)(() => dashboardServiceProvider(savedObjectClient, dashboardLocator), [savedObjectClient, dashboardLocator]);
}