"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectorService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _operators = require("rxjs/operators");
var _ml_api_service = require("./ml_api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AnomalyDetectorService {
  constructor(httpService) {
    (0, _defineProperty2.default)(this, "apiBasePath", (0, _ml_api_service.basePath)() + '/anomaly_detectors');
    this.httpService = httpService;
  }

  /**
   * Fetches a single job object
   * @param jobId
   */
  getJobById$(jobId) {
    return this.httpService.http$({
      path: `${this.apiBasePath}/${jobId}`
    }).pipe((0, _operators.map)(response => response.jobs[0]));
  }

  /**
   * Fetches anomaly detection jobs by ids
   * @param jobIds
   */
  getJobs$(jobIds) {
    return this.httpService.http$({
      path: `${this.apiBasePath}/${jobIds.join(',')}`
    }).pipe((0, _operators.map)(response => response.jobs));
  }

  /**
   * Extract unique influencers from the job or collection of jobs
   * @param jobs
   */
  extractInfluencers(jobs) {
    if (!Array.isArray(jobs)) {
      jobs = [jobs];
    }
    const influencers = new Set();
    for (const job of jobs) {
      for (const influencer of job.analysis_config.influencers || []) {
        influencers.add(influencer);
      }
    }
    return Array.from(influencers);
  }
}
exports.AnomalyDetectorService = AnomalyDetectorService;