"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActiveRoute = void 0;
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _app = require("../../../common/constants/app");
var _kibana = require("../contexts/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides an active route of the ML app.
 * @param routesList
 */
const useActiveRoute = routesList => {
  var _activeRoute$path;
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    services: {
      executionContext,
      overlays,
      theme
    }
  } = (0, _kibana.useMlKibana)();

  /**
   * Temp fix for routes with params.
   */
  const editCalendarMatch = (0, _reactRouterDom.useRouteMatch)('/settings/calendars_list/edit_calendar/:calendarId');
  const editFilterMatch = (0, _reactRouterDom.useRouteMatch)('/settings/filter_lists/edit_filter_list/:filterId');

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const routesMap = (0, _react.useMemo)(() => (0, _lodash.keyBy)(routesList, 'path'), []);
  const activeRoute = (0, _react.useMemo)(() => {
    if (editCalendarMatch) {
      return routesMap[editCalendarMatch.path];
    }
    if (editFilterMatch) {
      return routesMap[editFilterMatch.path];
    }
    // Remove trailing slash from the pathname
    const pathnameKey = pathname.replace(/\/$/, '');
    return routesMap[pathnameKey];
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [pathname]);
  const bannerId = (0, _react.useRef)();
  (0, _react.useEffect)(function handleNotFoundRoute() {
    if (!activeRoute && !!pathname) {
      bannerId.current = overlays.banners.replace(bannerId.current, (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        iconType: "iInCircle",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.notFoundPage.title",
          defaultMessage: "Page Not Found"
        }),
        "data-test-subj": 'mlPageNotFoundBanner'
      }, /*#__PURE__*/_react.default.createElement("p", {
        "data-test-subj": 'mlPageNotFoundBannerText'
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.notFoundPage.bannerText",
        defaultMessage: "The Machine Learning application doesn't recognize this route: {route}. You've been redirected to the Overview page.",
        values: {
          route: pathname
        }
      }))), {
        theme$: theme.theme$
      }));

      // hide the message after the user has had a chance to acknowledge it -- so it doesn't permanently stick around
      setTimeout(() => {
        if (bannerId.current) {
          overlays.banners.remove(bannerId.current);
        }
      }, 15000);
    }
  }, [activeRoute, overlays, theme, pathname]);
  (0, _public.useExecutionContext)(executionContext, {
    name: _app.PLUGIN_ID,
    type: 'application',
    page: (_activeRoute$path = activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute.path) !== null && _activeRoute$path !== void 0 ? _activeRoute$path : '/overview',
    id: activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute.path
  });
  return activeRoute !== null && activeRoute !== void 0 ? activeRoute : routesMap['/overview'];
};
exports.useActiveRoute = useActiveRoute;