"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelsListRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _resolvers = require("../../resolvers");
var _breadcrumbs = require("../../breadcrumbs");
var _model_management = require("../../../model_management");
var _page_header = require("../../../components/page_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const modelsListRouteFactory = (navigateToPath, basePath) => ({
  id: 'trained_models',
  path: (0, _router.createPath)(_locator.ML_PAGES.TRAINED_MODELS_MANAGE),
  title: _i18n.i18n.translate('xpack.ml.modelManagement.trainedModels.docTitle', {
    defaultMessage: 'Trained Models'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('TRAINED_MODELS', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.trainedModelsBreadcrumbs.trainedModelsLabel', {
      defaultMessage: 'Trained Models'
    })
  }],
  enableDatePicker: true,
  'data-test-subj': 'mlPageModelManagement'
});
exports.modelsListRouteFactory = modelsListRouteFactory;
const PageWrapper = ({
  location,
  deps
}) => {
  const {
    context
  } = (0, _use_resolver.useResolver)(undefined, undefined, deps.config, deps.dataViewsContract, deps.getSavedSearchDeps, (0, _resolvers.basicResolvers)(deps));
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: 'center',
    gutterSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.modelManagement.trainedModelsHeader",
    defaultMessage: "Trained Models"
  })))), /*#__PURE__*/_react.default.createElement(_model_management.ModelsList, null));
};