"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newFilterListRouteFactory = exports.editFilterListRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _locator = require("../../../../../common/constants/locator");
var _license = require("../../../license");
var _check_capabilities = require("../../../capabilities/check_capabilities");
var _check_ml_nodes = require("../../../ml_nodes_check/check_ml_nodes");
var _filter_lists = require("../../../settings/filter_lists");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _breadcrumbs = require("../../breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var MODE;
(function (MODE) {
  MODE[MODE["NEW"] = 0] = "NEW";
  MODE[MODE["EDIT"] = 1] = "EDIT";
})(MODE || (MODE = {}));
const newFilterListRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.FILTER_LISTS_NEW),
  title: _i18n.i18n.translate('xpack.ml.settings.createFilter.docTitle', {
    defaultMessage: 'Create Filter'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    mode: MODE.NEW,
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ANOMALY_DETECTION_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('SETTINGS_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('FILTER_LISTS_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.filterLists.createLabel', {
      defaultMessage: 'Create'
    })
  }]
});
exports.newFilterListRouteFactory = newFilterListRouteFactory;
const editFilterListRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.FILTER_LISTS_EDIT, '/:filterId'),
  title: _i18n.i18n.translate('xpack.ml.settings.editFilter.docTitle', {
    defaultMessage: 'Edit Filter'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    mode: MODE.EDIT,
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('SETTINGS_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('FILTER_LISTS_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.filterLists.editLabel', {
      defaultMessage: 'Edit'
    })
  }]
});
exports.editFilterListRouteFactory = editFilterListRouteFactory;
const PageWrapper = ({
  location,
  mode,
  deps
}) => {
  let filterId;
  if (mode === MODE.EDIT) {
    const pathMatch = location.pathname.match(/.+\/(.+)$/);
    filterId = pathMatch && pathMatch.length > 1 ? pathMatch[1] : undefined;
  }
  const {
    redirectToMlAccessDeniedPage
  } = deps;
  const {
    context
  } = (0, _use_resolver.useResolver)(undefined, undefined, deps.config, deps.dataViewsContract, deps.getSavedSearchDeps, {
    checkFullLicense: _license.checkFullLicense,
    checkGetJobsCapabilities: () => (0, _check_capabilities.checkGetJobsCapabilitiesResolver)(redirectToMlAccessDeniedPage),
    getMlNodeCount: _check_ml_nodes.getMlNodeCount
  });
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  const canCreateFilter = (0, _check_capabilities.checkPermission)('canCreateFilter');
  const canDeleteFilter = (0, _check_capabilities.checkPermission)('canDeleteFilter');
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_filter_lists.EditFilterList, {
    filterId,
    canCreateFilter,
    canDeleteFilter
  }));
};