"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newCalendarRouteFactory = exports.editCalendarRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _license = require("../../../license");
var _check_capabilities = require("../../../capabilities/check_capabilities");
var _calendars = require("../../../settings/calendars");
var _breadcrumbs = require("../../breadcrumbs");
var _locator = require("../../../../../common/constants/locator");
var _ml_nodes_check = require("../../../ml_nodes_check");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var MODE;
(function (MODE) {
  MODE[MODE["NEW"] = 0] = "NEW";
  MODE[MODE["EDIT"] = 1] = "EDIT";
})(MODE || (MODE = {}));
const newCalendarRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.CALENDARS_NEW),
  title: _i18n.i18n.translate('xpack.ml.settings.createCalendar.docTitle', {
    defaultMessage: 'Create Calendar'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    mode: MODE.NEW
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ANOMALY_DETECTION_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('SETTINGS_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('CALENDAR_MANAGEMENT_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.calendarManagement.createLabel', {
      defaultMessage: 'Create'
    })
  }]
});
exports.newCalendarRouteFactory = newCalendarRouteFactory;
const editCalendarRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.CALENDARS_EDIT, '/:calendarId'),
  title: _i18n.i18n.translate('xpack.ml.settings.editCalendar.docTitle', {
    defaultMessage: 'Edit Calendar'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    mode: MODE.EDIT
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('SETTINGS_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('CALENDAR_MANAGEMENT_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.calendarManagement.editLabel', {
      defaultMessage: 'Edit'
    })
  }]
});
exports.editCalendarRouteFactory = editCalendarRouteFactory;
const PageWrapper = ({
  location,
  mode,
  deps
}) => {
  let calendarId;
  if (mode === MODE.EDIT) {
    const pathMatch = location.pathname.match(/.+\/(.+)$/);
    calendarId = pathMatch && pathMatch.length > 1 ? pathMatch[1] : undefined;
  }
  const {
    redirectToMlAccessDeniedPage
  } = deps;
  const {
    context
  } = (0, _use_resolver.useResolver)(undefined, undefined, deps.config, deps.dataViewsContract, deps.getSavedSearchDeps, {
    checkFullLicense: _license.checkFullLicense,
    checkGetJobsCapabilities: () => (0, _check_capabilities.checkGetJobsCapabilitiesResolver)(redirectToMlAccessDeniedPage),
    getMlNodeCount: _ml_nodes_check.getMlNodeCount
  });
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  const canCreateCalendar = (0, _check_capabilities.checkPermission)('canCreateCalendar');
  const canDeleteCalendar = (0, _check_capabilities.checkPermission)('canDeleteCalendar');
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_calendars.NewCalendar, {
    calendarId,
    canCreateCalendar,
    canDeleteCalendar
  }));
};