"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overviewRouteFactory = exports.appRootRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _locator = require("../../../locator");
var _license = require("../../license");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _ml_nodes_check = require("../../ml_nodes_check");
var _ml_server_info = require("../../services/ml_server_info");
var _router = require("../router");
var _use_resolver = require("../use_resolver");
var _breadcrumbs = require("../breadcrumbs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const OverviewPage = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../overview/overview_page'))));
const overviewRouteFactory = (navigateToPath, basePath) => ({
  id: 'overview',
  path: (0, _router.createPath)(_locator.ML_PAGES.OVERVIEW),
  title: _i18n.i18n.translate('xpack.ml.overview.overviewLabel', {
    defaultMessage: 'Overview'
  }),
  enableDatePicker: true,
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.overview.overviewLabel', {
      defaultMessage: 'Overview'
    })
  }],
  'data-test-subj': 'mlPageOverview'
});
exports.overviewRouteFactory = overviewRouteFactory;
const PageWrapper = ({
  deps
}) => {
  const {
    redirectToMlAccessDeniedPage
  } = deps;
  const {
    context
  } = (0, _use_resolver.useResolver)(undefined, undefined, deps.config, deps.dataViewsContract, deps.getSavedSearchDeps, {
    checkFullLicense: _license.checkFullLicense,
    checkGetJobsCapabilities: () => (0, _check_capabilities.checkGetJobsCapabilitiesResolver)(redirectToMlAccessDeniedPage),
    getMlNodeCount: _ml_nodes_check.getMlNodeCount,
    loadMlServerInfo: _ml_server_info.loadMlServerInfo
  });
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, /*#__PURE__*/_react.default.createElement(OverviewPage, null)));
};
const appRootRouteFactory = (navigateToPath, basePath) => ({
  id: '',
  path: '/',
  render: () => /*#__PURE__*/_react.default.createElement(Page, null),
  breadcrumbs: []
});
exports.appRootRouteFactory = appRootRouteFactory;
const Page = () => {
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: (0, _router.createPath)(_locator.ML_PAGES.OVERVIEW)
  });
};