"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.recognizeRouteFactory = exports.checkViewOrCreateRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _queryString = require("query-string");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _locator = require("../../../../locator");
var _kibana = require("../../../contexts/kibana");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _resolvers = require("../../resolvers");
var _recognize = require("../../../jobs/new_job/recognize");
var _resolvers2 = require("../../../jobs/new_job/recognize/resolvers");
var _job_service = require("../../../services/job_service");
var _breadcrumbs = require("../../breadcrumbs");
var _use_create_ad_links = require("../../../components/custom_hooks/use_create_ad_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const recognizeRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_RECOGNIZER),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ANOMALY_DETECTION_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('CREATE_JOB_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.selectIndexOrSearchLabelRecognize', {
      defaultMessage: 'Recognized index'
    }),
    href: ''
  }]
});
exports.recognizeRouteFactory = recognizeRouteFactory;
const checkViewOrCreateRouteFactory = () => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_MODULES_VIEW_OR_CREATE),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(CheckViewOrCreateWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  // no breadcrumbs since it's just a redirect
  breadcrumbs: []
});
exports.checkViewOrCreateRouteFactory = checkViewOrCreateRouteFactory;
const PageWrapper = ({
  location,
  deps
}) => {
  const {
    id,
    index,
    savedSearchId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const {
    context,
    results
  } = (0, _use_resolver.useResolver)(index, savedSearchId, deps.config, deps.dataViewsContract, deps.getSavedSearchDeps, {
    ...(0, _resolvers.basicResolvers)(deps),
    existingJobsAndGroups: _job_service.mlJobService.getJobAndGroupIds
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_recognize.Page, {
    moduleId: id,
    existingGroupIds: results.existingJobsAndGroups.groupIds
  }));
};
const CheckViewOrCreateWrapper = ({
  location,
  deps
}) => {
  const {
    id: moduleId,
    index: dataViewId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const {
    createLinkWithUserDefaults
  } = (0, _use_create_ad_links.useCreateADLinks)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();

  // the single resolver checkViewOrCreateJobs redirects only. so will always reject
  (0, _use_resolver.useResolver)(undefined, undefined, deps.config, deps.dataViewsContract, deps.getSavedSearchDeps, {
    checkViewOrCreateJobs: () => (0, _resolvers2.checkViewOrCreateJobs)(moduleId, dataViewId, createLinkWithUserDefaults, navigateToPath)
  });
  return null;
};