"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobTypeRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _queryString = require("query-string");
var _i18n = require("@kbn/i18n");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _resolvers = require("../../resolvers");
var _job_type = require("../../../jobs/new_job/pages/job_type");
var _breadcrumbs = require("../../breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const jobTypeRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_TYPE),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ANOMALY_DETECTION_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.selectJobType', {
      defaultMessage: 'Create job'
    }),
    href: ''
  }]
});
exports.jobTypeRouteFactory = jobTypeRouteFactory;
const PageWrapper = ({
  location,
  deps
}) => {
  const {
    index,
    savedSearchId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const {
    context
  } = (0, _use_resolver.useResolver)(index, savedSearchId, deps.config, deps.dataViewsContract, deps.getSavedSearchDeps, (0, _resolvers.basicResolvers)(deps));
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_job_type.Page, null));
};