"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexBasedRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _queryString = require("query-string");
var _i18n = require("@kbn/i18n");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _index_data_visualizer = require("../../../datavisualizer/index_based/index_data_visualizer");
var _license = require("../../../license");
var _check_capabilities = require("../../../capabilities/check_capabilities");
var _index_utils = require("../../../util/index_utils");
var _breadcrumbs = require("../../breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexBasedRouteFactory = (navigateToPath, basePath) => ({
  id: 'data_view_datavisualizer',
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_VISUALIZER_INDEX_VIEWER),
  title: _i18n.i18n.translate('xpack.ml.dataVisualizer.dataView.docTitle', {
    defaultMessage: 'Index Data Visualizer'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_VISUALIZER_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.dataFrameAnalyticsBreadcrumbs.dataViewLabel', {
      defaultMessage: 'Data View'
    })
  }]
});
exports.indexBasedRouteFactory = indexBasedRouteFactory;
const PageWrapper = ({
  location,
  deps
}) => {
  const {
    redirectToMlAccessDeniedPage
  } = deps;
  const {
    index,
    savedSearchId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const {
    context
  } = (0, _use_resolver.useResolver)(index, savedSearchId, deps.config, deps.dataViewsContract, deps.getSavedSearchDeps, {
    checkBasicLicense: _license.checkBasicLicense,
    cacheDataViewsContract: () => (0, _index_utils.cacheDataViewsContract)(deps.dataViewsContract),
    checkGetJobsCapabilities: () => (0, _check_capabilities.checkGetJobsCapabilitiesResolver)(redirectToMlAccessDeniedPage)
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_index_data_visualizer.IndexDataVisualizerPage, null));
};