"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectorRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _datavisualizer = require("../../../datavisualizer");
var _license = require("../../../license");
var _check_capabilities = require("../../../capabilities/check_capabilities");
var _breadcrumbs = require("../../breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectorRouteFactory = (navigateToPath, basePath) => ({
  id: 'datavisualizer',
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_VISUALIZER),
  title: _i18n.i18n.translate('xpack.ml.dataVisualizer.docTitle', {
    defaultMessage: 'Data Visualizer'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_VISUALIZER_BREADCRUMB')]
});
exports.selectorRouteFactory = selectorRouteFactory;
const PageWrapper = ({
  location,
  deps
}) => {
  const {
    redirectToMlAccessDeniedPage
  } = deps;
  const {
    context
  } = (0, _use_resolver.useResolver)(undefined, undefined, deps.config, deps.dataViewsContract, deps.getSavedSearchDeps, {
    checkBasicLicense: _license.checkBasicLicense,
    checkFindFileStructurePrivilege: () => (0, _check_capabilities.checkFindFileStructurePrivilegeResolver)(redirectToMlAccessDeniedPage)
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_datavisualizer.DatavisualizerSelector, null));
};