"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.analyticsJobsListRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _resolvers = require("../../resolvers");
var _analytics_management = require("../../../data_frame_analytics/pages/analytics_management");
var _breadcrumbs = require("../../breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const analyticsJobsListRouteFactory = (navigateToPath, basePath) => ({
  id: 'data_frame_analytics',
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE),
  title: _i18n.i18n.translate('xpack.ml.dataFrameAnalytics.jobs.docTitle', {
    defaultMessage: 'Data Frame Analytics Jobs'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_FRAME_ANALYTICS_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.dataFrameAnalyticsBreadcrumbs.jobsManagementLabel', {
      defaultMessage: 'Jobs'
    })
  }],
  'data-test-subj': 'mlPageDataFrameAnalytics',
  enableDatePicker: true
});
exports.analyticsJobsListRouteFactory = analyticsJobsListRouteFactory;
const PageWrapper = ({
  location,
  deps
}) => {
  const {
    context
  } = (0, _use_resolver.useResolver)(undefined, undefined, deps.config, deps.dataViewsContract, deps.getSavedSearchDeps, (0, _resolvers.basicResolvers)(deps));
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_analytics_management.Page, null));
};