"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.explainLogRateSpikesRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _queryString = require("query-string");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/aiops-plugin/common");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _explain_log_rate_spikes = require("../../../aiops/explain_log_rate_spikes");
var _license = require("../../../license");
var _check_capabilities = require("../../../capabilities/check_capabilities");
var _index_utils = require("../../../util/index_utils");
var _breadcrumbs = require("../../breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const explainLogRateSpikesRouteFactory = (navigateToPath, basePath) => ({
  id: 'explain_log_rate_spikes',
  path: (0, _router.createPath)(_locator.ML_PAGES.AIOPS_EXPLAIN_LOG_RATE_SPIKES),
  title: _i18n.i18n.translate('xpack.ml.aiops.explainLogRateSpikes.docTitle', {
    defaultMessage: 'Explain log rate spikes'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('AIOPS_BREADCRUMB_EXPLAIN_LOG_RATE_SPIKES', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbs.explainLogRateSpikesLabel', {
      defaultMessage: 'Explain log rate spikes'
    })
  }],
  disabled: !_common.AIOPS_ENABLED
});
exports.explainLogRateSpikesRouteFactory = explainLogRateSpikesRouteFactory;
const PageWrapper = ({
  location,
  deps,
  ...restProps
}) => {
  const {
    redirectToMlAccessDeniedPage
  } = deps;
  const {
    index,
    savedSearchId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const {
    context
  } = (0, _use_resolver.useResolver)(index, savedSearchId, deps.config, deps.dataViewsContract, deps.getSavedSearchDeps, {
    checkBasicLicense: _license.checkBasicLicense,
    cacheDataViewsContract: () => (0, _index_utils.cacheDataViewsContract)(deps.dataViewsContract),
    checkGetJobsCapabilities: () => (0, _check_capabilities.checkGetJobsCapabilitiesResolver)(redirectToMlAccessDeniedPage)
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_explain_log_rate_spikes.ExplainLogRateSpikesPage, null));
};