"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.accessDeniedRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _locator = require("../../../locator");
var _router = require("../router");
var _use_resolver = require("../use_resolver");
var _access_denied = require("../../access_denied");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const breadcrumbs = [{
  text: _i18n.i18n.translate('xpack.ml.accessDeniedLabel', {
    defaultMessage: 'Access denied'
  })
}];
const accessDeniedRouteFactory = () => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ACCESS_DENIED),
  title: _i18n.i18n.translate('xpack.ml.accessDeniedLabel', {
    defaultMessage: 'Access denied'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs
});
exports.accessDeniedRouteFactory = accessDeniedRouteFactory;
const PageWrapper = ({
  deps
}) => {
  const {
    context
  } = (0, _use_resolver.useResolver)(undefined, undefined, deps.config, deps.dataViewsContract, deps.getSavedSearchDeps, {});
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_access_denied.Page, null));
};