"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.basicResolvers = void 0;
var _index_utils = require("../util/index_utils");
var _license = require("../license");
var _check_capabilities = require("../capabilities/check_capabilities");
var _check_ml_nodes = require("../ml_nodes_check/check_ml_nodes");
var _ml_server_info = require("../services/ml_server_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const basicResolvers = ({
  dataViewsContract,
  redirectToMlAccessDeniedPage
}) => ({
  checkFullLicense: _license.checkFullLicense,
  getMlNodeCount: _check_ml_nodes.getMlNodeCount,
  loadMlServerInfo: _ml_server_info.loadMlServerInfo,
  cacheDataViewsContract: () => (0, _index_utils.cacheDataViewsContract)(dataViewsContract),
  checkGetJobsCapabilities: () => (0, _check_capabilities.checkGetJobsCapabilitiesResolver)(redirectToMlAccessDeniedPage),
  loadSavedSearches: _index_utils.loadSavedSearches
});
exports.basicResolvers = basicResolvers;