"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.OverviewPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _check_capabilities = require("../capabilities/check_capabilities");
var _ml_nodes_check = require("../ml_nodes_check");
var _content = require("./components/content");
var _node_available_warning = require("../components/node_available_warning");
var _jobs_awaiting_node_warning = require("../components/jobs_awaiting_node_warning");
var _saved_objects_warning = require("../components/saved_objects_warning");
var _upgrade = require("../components/upgrade");
var _help_menu = require("../components/help_menu");
var _kibana = require("../contexts/kibana");
var _nodes_overview = require("../memory_usage/nodes_overview");
var _page_header = require("../components/page_header");
var _page_title = require("../components/page_title");
var _use_is_serverless = require("../contexts/kibana/use_is_serverless");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewPage = () => {
  const serverless = (0, _use_is_serverless.useIsServerless)();
  const canViewMlNodes = (0, _check_capabilities.checkPermission)('canViewMlNodes');
  const disableCreateAnomalyDetectionJob = !(0, _check_capabilities.checkPermission)('canCreateJob') || !(0, _ml_nodes_check.mlNodesAvailable)();
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const helpLink = docLinks.links.ml.guide;
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: true,
    autoRefreshSelector: true
  });
  const [adLazyJobCount, setAdLazyJobCount] = (0, _react.useState)(0);
  const [dfaLazyJobCount, setDfaLazyJobCount] = (0, _react.useState)(0);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: _i18n.i18n.translate('xpack.ml.overview.overviewLabel', {
      defaultMessage: 'Overview'
    })
  })), /*#__PURE__*/_react.default.createElement(_node_available_warning.NodeAvailableWarning, null), /*#__PURE__*/_react.default.createElement(_jobs_awaiting_node_warning.JobsAwaitingNodeWarning, {
    jobCount: adLazyJobCount + dfaLazyJobCount
  }), /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: () => {
      const {
        from,
        to
      } = timefilter.getTime();
      const timeRange = {
        start: from,
        end: to
      };
      _mlDatePicker.mlTimefilterRefresh$.next({
        lastRefresh: Date.now(),
        timeRange
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_upgrade.UpgradeWarning, null), canViewMlNodes && serverless === false ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_nodes_overview.NodesList, {
    compactView: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, /*#__PURE__*/_react.default.createElement(_content.OverviewContent, {
    createAnomalyDetectionJobDisabled: disableCreateAnomalyDetectionJob,
    setAdLazyJobCount: setAdLazyJobCount,
    setDfaLazyJobCount: setDfaLazyJobCount
  }), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink
  }));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.OverviewPage = OverviewPage;
var _default = OverviewPage;
exports.default = _default;