"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _anomaly_detection_panel = require("./anomaly_detection_panel");
var _analytics_panel = require("./analytics_panel");
var _anomaly_timeline_service = require("../../services/anomaly_timeline_service");
var _results_service = require("../../services/results_service");
var _kibana = require("../../contexts/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewContent = ({
  createAnomalyDetectionJobDisabled,
  setAdLazyJobCount,
  setDfaLazyJobCount
}) => {
  const {
    services: {
      uiSettings,
      mlServices: {
        mlApiServices
      }
    }
  } = (0, _kibana.useMlKibana)();
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const [anomalyTimelineService, setAnomalyTimelineService] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    setAnomalyTimelineService(new _anomaly_timeline_service.AnomalyTimelineService(timefilter, uiSettings, (0, _results_service.mlResultsServiceProvider)(mlApiServices)));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  if (anomalyTimelineService === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_anomaly_detection_panel.AnomalyDetectionPanel, {
    anomalyTimelineService: anomalyTimelineService,
    jobCreationDisabled: createAnomalyDetectionJobDisabled,
    setLazyJobCount: setAdLazyJobCount
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_analytics_panel.AnalyticsPanel, {
    setLazyJobCount: setDfaLazyJobCount
  }));
};
exports.OverviewContent = OverviewContent;