"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGroupActions = useGroupActions;
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _kibana = require("../../../contexts/kibana");
var _locator = require("../../../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGroupActions() {
  const locator = (0, _kibana.useMlLocator)();
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  return [{
    isPrimary: true,
    name: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.viewJobsActionName', {
      defaultMessage: 'View jobs'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.resultActions.openInJobManagementText', {
      defaultMessage: 'View jobs'
    }),
    icon: 'list',
    type: 'icon',
    onClick: async item => {
      const path = await (locator === null || locator === void 0 ? void 0 : locator.getUrl({
        page: _locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE,
        pageState: {
          groupIds: [item.id]
        }
      }));
      await navigateToPath(path);
    }
  }, {
    isPrimary: false,
    name: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.viewResultsActionName', {
      defaultMessage: 'View in Anomaly Explorer'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.resultActions.openJobsInAnomalyExplorerText', {
      defaultMessage: 'View in Anomaly Explorer'
    }),
    icon: 'visTable',
    type: 'icon',
    onClick: async item => {
      const path = await (locator === null || locator === void 0 ? void 0 : locator.getUrl({
        page: _locator.ML_PAGES.ANOMALY_EXPLORER,
        pageState: {
          jobIds: item.jobIds,
          timeRange: timefilter.getTime()
        }
      }));
      await navigateToPath(path);
    }
  }];
}