"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _analytics = require("../../../data_frame_analytics/common/analytics");
var _common = require("../../../data_frame_analytics/pages/analytics_management/components/analytics_list/common");
var _use_columns = require("../../../data_frame_analytics/pages/analytics_management/components/analytics_list/use_columns");
var _date_utils = require("../../../../../common/util/date_utils");
var _actions = require("./actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsTable = ({
  items
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)(_common.DataFrameAnalyticsListColumn.id);
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const columns = [{
    field: _common.DataFrameAnalyticsListColumn.id,
    name: _i18n.i18n.translate('xpack.ml.overview.analyticsList.id', {
      defaultMessage: 'ID'
    }),
    sortable: true,
    truncateText: false,
    width: '20%'
  }, {
    name: _i18n.i18n.translate('xpack.ml.overview.analyticsList.type', {
      defaultMessage: 'Type'
    }),
    sortable: item => (0, _analytics.getAnalysisType)(item.config.analysis),
    truncateText: true,
    render(item) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, (0, _analytics.getAnalysisType)(item.config.analysis));
    },
    width: '150px'
  }, {
    name: _i18n.i18n.translate('xpack.ml.overview.analyticsList.status', {
      defaultMessage: 'Status'
    }),
    sortable: item => item.stats.state,
    truncateText: true,
    render(item) {
      return (0, _use_columns.getTaskStateBadge)(item.stats.state, item.stats.failure_reason);
    },
    width: '100px'
  }, _use_columns.progressColumn, {
    field: _common.DataFrameAnalyticsListColumn.configCreateTime,
    name: _i18n.i18n.translate('xpack.ml.overview.analyticsList.reatedTimeColumnName', {
      defaultMessage: 'Creation time'
    }),
    dataType: 'date',
    render: time => (0, _date_utils.formatHumanReadableDateTime)(time),
    textOnly: true,
    truncateText: true,
    sortable: true,
    width: '25%'
  }, {
    name: _i18n.i18n.translate('xpack.ml.overview.analyticsList.tableActionLabel', {
      defaultMessage: 'Actions'
    }),
    actions: (0, _actions.useTableActions)(),
    width: '80px'
  }];
  const onTableChange = ({
    page = {
      index: 0,
      size: 10
    },
    sort = {
      field: _common.DataFrameAnalyticsListColumn.id,
      direction: 'asc'
    }
  }) => {
    const {
      index,
      size
    } = page;
    setPageIndex(index);
    setPageSize(size);
    const {
      field,
      direction
    } = sort;
    setSortField(field);
    setSortDirection(direction);
  };
  const pagination = {
    initialPageIndex: pageIndex,
    initialPageSize: pageSize,
    totalItemCount: items.length,
    pageSizeOptions: [10, 20, 50],
    showPerPageOptions: true
  };
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    allowNeutralSort: false,
    className: "mlAnalyticsTable",
    columns: columns,
    hasActions: true,
    isExpandable: false,
    isSelectable: false,
    items: items,
    itemId: _common.DataFrameAnalyticsListColumn.id,
    onTableChange: onTableChange,
    pagination: pagination,
    sorting: sorting,
    "data-test-subj": "mlOverviewTableAnalytics"
  });
};
exports.AnalyticsTable = AnalyticsTable;