"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _table = require("./table");
var _analytics_service = require("../../../data_frame_analytics/pages/analytics_management/services/analytics_service");
var _stats_bar = require("../../../components/stats_bar");
var _kibana = require("../../../contexts/kibana");
var _locator = require("../../../../../common/constants/locator");
var _use_refresh = require("../../../routing/use_refresh");
var _empty_prompt = require("../../../data_frame_analytics/pages/analytics_management/components/empty_prompt");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsPanel = ({
  setLazyJobCount
}) => {
  const refresh = (0, _use_refresh.useRefresh)();
  const [analytics, setAnalytics] = (0, _react.useState)([]);
  const [analyticsStats, setAnalyticsStats] = (0, _react.useState)(undefined);
  const [errorMessage, setErrorMessage] = (0, _react.useState)();
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const manageJobsLink = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE
  });
  const getAnalytics = (0, _analytics_service.getAnalyticsFactory)(setAnalytics, setAnalyticsStats, setErrorMessage, setIsInitialized, setLazyJobCount, false);
  (0, _react.useEffect)(() => {
    getAnalytics(true);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refresh]);
  const errorDisplay = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.overview.analyticsList.errorPromptTitle', {
      defaultMessage: 'An error occurred getting the data frame analytics list.'
    }),
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("pre", null, errorMessage && errorMessage.message !== undefined ? errorMessage.message : JSON.stringify(errorMessage)));
  const noDFAJobs = errorMessage === undefined && isInitialized === true && analytics.length === 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, noDFAJobs ? /*#__PURE__*/_react.default.createElement(_empty_prompt.AnalyticsEmptyPrompt, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: isInitialized ? {} : {
      textAlign: 'center',
      padding: '10%'
    },
    hasShadow: false,
    hasBorder: true
  }, typeof errorMessage !== 'undefined' ? errorDisplay : null, isInitialized === false && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    css: {
      display: 'inline-block'
    },
    size: "xl"
  }), isInitialized === true && analytics.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.ml.overview.analyticsList.PanelTitle', {
    defaultMessage: 'Analytics'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's',
    alignItems: "center"
  }, analyticsStats !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_stats_bar.StatsBar, {
    stats: analyticsStats,
    dataTestSub: 'mlOverviewAnalyticsStatsBar'
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "m",
    fill: true,
    href: manageJobsLink
  }, _i18n.i18n.translate('xpack.ml.overview.analyticsList.manageJobsButtonText', {
    defaultMessage: 'Manage jobs'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_table.AnalyticsTable, {
    items: analytics
  }))));
};
exports.AnalyticsPanel = AnalyticsPanel;