"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewLink = void 0;
exports.useTableActions = useTableActions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../contexts/kibana");
var _analytics = require("../../../data_frame_analytics/common/analytics");
var _get_view_link_status = require("../../../data_frame_analytics/pages/analytics_management/components/action_view/get_view_link_status");
var _locator = require("../../../../../common/constants/locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ViewLink = ({
  item
}) => {
  const {
    disabled,
    tooltipContent
  } = (0, _get_view_link_status.getViewLinkStatus)(item);
  const viewJobResultsButtonText = _i18n.i18n.translate('xpack.ml.overview.analytics.resultActions.openJobText', {
    defaultMessage: 'View job results'
  });
  const tooltipText = disabled === false ? viewJobResultsButtonText : tooltipContent;
  const analysisType = (0, _react.useMemo)(() => (0, _analytics.getAnalysisType)(item.config.analysis), [item]);
  const viewAnalyticsResultsLink = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION,
    pageState: {
      jobId: item.id,
      analysisType: analysisType
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tooltipText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    href: viewAnalyticsResultsLink,
    size: "xs",
    iconType: "visTable",
    "aria-label": viewJobResultsButtonText,
    "data-test-subj": "mlOverviewAnalyticsJobViewButton",
    isDisabled: disabled
  }));
};
exports.ViewLink = ViewLink;
function useTableActions() {
  const locator = (0, _kibana.useMlLocator)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  return [{
    isPrimary: false,
    name: _i18n.i18n.translate('xpack.ml.overview.analytics.viewJobActionName', {
      defaultMessage: 'View job'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.analytics.viewJobActionName', {
      defaultMessage: 'View job'
    }),
    type: 'icon',
    icon: 'list',
    onClick: async item => {
      const path = await (locator === null || locator === void 0 ? void 0 : locator.getUrl({
        page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE,
        pageState: {
          jobId: item.id
        }
      }));
      await navigateToPath(path);
    }
  }, {
    isPrimary: false,
    name: _i18n.i18n.translate('xpack.ml.overview.analytics.viewResultsActionName', {
      defaultMessage: 'View results'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.analytics.resultActions.openJobText', {
      defaultMessage: 'View job results'
    }),
    render: item => /*#__PURE__*/_react.default.createElement(ViewLink, {
      item: item
    })
  }];
}