"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTestable = isTestable;
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PYTORCH_TYPES = Object.values(_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS).filter(taskType => taskType !== _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EXPANSION);
function isTestable(modelItem, checkForState = false) {
  var _modelItem$stats, _modelItem$stats$depl;
  if (modelItem.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.PYTORCH && PYTORCH_TYPES.includes(Object.keys(modelItem.inference_config)[0]) && (checkForState === false || (_modelItem$stats = modelItem.stats) !== null && _modelItem$stats !== void 0 && (_modelItem$stats$depl = _modelItem$stats.deployment_stats) !== null && _modelItem$stats$depl !== void 0 && _modelItem$stats$depl.some(v => v.state === _mlTrainedModelsUtils.DEPLOYMENT_STATE.STARTED))) {
    return true;
  }
  if (modelItem.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.LANG_IDENT) {
    return true;
  }
  return false;
}