"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestTrainedModelFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _selected_model = require("./selected_model");
var _inference_base = require("./models/inference_base");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TestTrainedModelFlyout = ({
  model,
  onClose
}) => {
  const [deploymentId, setDeploymentId] = (0, _react.useState)(model.deployment_ids[0]);
  const mediumPadding = (0, _eui.useEuiPaddingSize)('m');
  const [inputType, setInputType] = (0, _react.useState)(_inference_base.INPUT_TYPE.TEXT);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    maxWidth: 600,
    onClose: onClose,
    "data-test-subj": "mlTestModelsFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.headerLabel",
    defaultMessage: "Test trained model"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, model.model_id))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, model.deployment_ids.length > 1 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.testModelsFlyout.deploymentIdLabel",
      defaultMessage: "Deployment ID"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    options: model.deployment_ids.map(v => {
      return {
        text: v,
        value: v
      };
    }),
    value: deploymentId,
    onChange: e => {
      setDeploymentId(e.target.value);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "m",
    css: {
      marginTop: `-${mediumPadding}`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: inputType === _inference_base.INPUT_TYPE.TEXT,
    onClick: () => setInputType(_inference_base.INPUT_TYPE.TEXT)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.textTab",
    defaultMessage: "Test using text"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: inputType === _inference_base.INPUT_TYPE.INDEX,
    onClick: () => setInputType(_inference_base.INPUT_TYPE.INDEX)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.indexTab",
    defaultMessage: "Test using existing index"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_selected_model.SelectedModel, {
    model: model,
    inputType: inputType,
    deploymentId: deploymentId !== null && deploymentId !== void 0 ? deploymentId : model.model_id
  }))));
};
exports.TestTrainedModelFlyout = TestTrainedModelFlyout;