"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processInferenceResult = processInferenceResult;
exports.processResponse = processResponse;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROBABILITY_SIG_FIGS = 3;
function processResponse(resp, model, inputText) {
  const {
    inference_results: [inferenceResult]
  } = resp;
  const formattedResponse = processInferenceResult(inferenceResult, model);
  return {
    response: formattedResponse,
    rawResponse: resp,
    inputText
  };
}
function processInferenceResult(inferenceResult, model) {
  var _model$inference_conf, _model$inference_conf2;
  const labels = (_model$inference_conf = (_model$inference_conf2 = model.inference_config.text_classification) === null || _model$inference_conf2 === void 0 ? void 0 : _model$inference_conf2.classification_labels) !== null && _model$inference_conf !== void 0 ? _model$inference_conf : [];
  let formattedResponse = [{
    value: inferenceResult.predicted_value,
    predictionProbability: inferenceResult.prediction_probability
  }];
  if (inferenceResult.top_classes !== undefined) {
    // if num_top_classes has been specified in the model,
    // base the returned results on this list
    formattedResponse = inferenceResult.top_classes.map(topClass => {
      return {
        value: topClass.class_name,
        predictionProbability: topClass.class_probability
      };
    });
  } else if (labels.length === 2) {
    // otherwise, if the config only contains two classification_labels
    // we can safely assume the non-top value and return two results
    formattedResponse = labels.map(value => {
      const predictionProbability = inferenceResult.predicted_value === value ? inferenceResult.prediction_probability : 1 - inferenceResult.prediction_probability;
      return {
        value,
        predictionProbability
      };
    });
  }
  return formattedResponse.map(({
    value,
    predictionProbability
  }) => ({
    value,
    predictionProbability: Number(predictionProbability.toPrecision(PROBABILITY_SIG_FIGS))
  })).sort((a, b) => a.predictionProbability - b.predictionProbability).reverse();
}