"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RUNNING_STATE = exports.InferenceBase = exports.INPUT_TYPE = exports.DEFAULT_INFERENCE_TIME_OUT = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _operators = require("rxjs/operators");
var _inference_info = require("./inference_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_INPUT_FIELD = 'text_field';
const DEFAULT_INFERENCE_TIME_OUT = '30s';
exports.DEFAULT_INFERENCE_TIME_OUT = DEFAULT_INFERENCE_TIME_OUT;
let RUNNING_STATE;
exports.RUNNING_STATE = RUNNING_STATE;
(function (RUNNING_STATE) {
  RUNNING_STATE[RUNNING_STATE["STOPPED"] = 0] = "STOPPED";
  RUNNING_STATE[RUNNING_STATE["RUNNING"] = 1] = "RUNNING";
  RUNNING_STATE[RUNNING_STATE["FINISHED"] = 2] = "FINISHED";
  RUNNING_STATE[RUNNING_STATE["FINISHED_WITH_ERRORS"] = 3] = "FINISHED_WITH_ERRORS";
})(RUNNING_STATE || (exports.RUNNING_STATE = RUNNING_STATE = {}));
let INPUT_TYPE;
exports.INPUT_TYPE = INPUT_TYPE;
(function (INPUT_TYPE) {
  INPUT_TYPE[INPUT_TYPE["TEXT"] = 0] = "TEXT";
  INPUT_TYPE[INPUT_TYPE["INDEX"] = 1] = "INDEX";
})(INPUT_TYPE || (exports.INPUT_TYPE = INPUT_TYPE = {}));
class InferenceBase {
  constructor(trainedModelsApi, model, inputType, deploymentId) {
    var _model$input$field_na, _model$input;
    (0, _defineProperty2.default)(this, "modelInputField", void 0);
    (0, _defineProperty2.default)(this, "_deploymentId", null);
    (0, _defineProperty2.default)(this, "inputText$", new _rxjs.BehaviorSubject([]));
    (0, _defineProperty2.default)(this, "inputField$", new _rxjs.BehaviorSubject(''));
    (0, _defineProperty2.default)(this, "inferenceResult$", new _rxjs.BehaviorSubject(null));
    (0, _defineProperty2.default)(this, "inferenceError$", new _rxjs.BehaviorSubject(null));
    (0, _defineProperty2.default)(this, "runningState$", new _rxjs.BehaviorSubject(RUNNING_STATE.STOPPED));
    (0, _defineProperty2.default)(this, "isValid$", new _rxjs.BehaviorSubject(false));
    (0, _defineProperty2.default)(this, "pipeline$", new _rxjs.BehaviorSubject({}));
    (0, _defineProperty2.default)(this, "info", []);
    (0, _defineProperty2.default)(this, "subscriptions$", new _rxjs.Subscription());
    this.trainedModelsApi = trainedModelsApi;
    this.model = model;
    this.inputType = inputType;
    this.deploymentId = deploymentId;
    this.modelInputField = (_model$input$field_na = (_model$input = model.input) === null || _model$input === void 0 ? void 0 : _model$input.field_names[0]) !== null && _model$input$field_na !== void 0 ? _model$input$field_na : DEFAULT_INPUT_FIELD;
    this.inputField$.next(this.modelInputField);
  }
  destroy() {
    this.subscriptions$.unsubscribe();
  }
  initialize(additionalValidators, additionalChanges) {
    this.initializeValidators(additionalValidators);
    this.initializePipeline(additionalChanges);
  }
  initializeValidators(additionalValidators) {
    const validators$ = [this.inputText$.pipe((0, _operators.map)(inputText => inputText.some(t => t !== ''))), ...(additionalValidators ? additionalValidators : [])];
    this.subscriptions$.add((0, _rxjs.combineLatest)(validators$).pipe((0, _operators.map)(validationResults => {
      return validationResults.every(v => !!v);
    })).subscribe(this.isValid$));
  }
  initializePipeline(additionalChanges) {
    const formObservables$ = [this.inputField$.asObservable(), ...(additionalChanges ? additionalChanges : [])];
    this.subscriptions$.add((0, _rxjs.combineLatest)(formObservables$).subscribe(() => {
      this.pipeline$.next(this.generatePipeline());
    }));
  }
  setStopped() {
    this.inferenceError$.next(null);
    this.runningState$.next(RUNNING_STATE.STOPPED);
  }
  setRunning() {
    this.inferenceError$.next(null);
    this.runningState$.next(RUNNING_STATE.RUNNING);
  }
  setFinished() {
    this.runningState$.next(RUNNING_STATE.FINISHED);
  }
  setFinishedWithErrors(error) {
    this.inferenceError$.next(error);
    this.runningState$.next(RUNNING_STATE.FINISHED_WITH_ERRORS);
  }
  getInfoComponent() {
    return (0, _inference_info.getInferenceInfoComponent)(this.inferenceTypeLabel, this.info);
  }
  getInputType() {
    return this.inputType;
  }
  reset() {
    this.inputText$.next([]);
    this.inferenceResult$.next(null);
    this.inferenceError$.next(null);
    this.runningState$.next(RUNNING_STATE.STOPPED);
  }
  setInputField(field) {
    // if the field is not set, change to be the same as the model input field
    this.inputField$.next(field === undefined ? this.modelInputField : field);
  }
  getInputField() {
    return this.inputField$.getValue();
  }
  getInputField$() {
    return this.inputField$.asObservable();
  }
  setInputText(text) {
    this.inputText$.next(text);
  }
  getInputText$() {
    return this.inputText$.asObservable();
  }
  getInputText() {
    return this.inputText$.getValue();
  }
  getInferenceResult$() {
    return this.inferenceResult$.asObservable();
  }
  getInferenceResult() {
    return this.inferenceResult$.getValue();
  }
  getInferenceError$() {
    return this.inferenceError$.asObservable();
  }
  getInferenceError() {
    return this.inferenceError$.getValue();
  }
  getRunningState$() {
    return this.runningState$.asObservable();
  }
  getRunningState() {
    return this.runningState$.getValue();
  }
  getIsValid$() {
    return this.isValid$.asObservable();
  }
  getIsValid() {
    return this.isValid$.getValue();
  }
  async infer() {
    return this.inputType === INPUT_TYPE.TEXT ? this.inferText() : this.inferIndex();
  }
  generatePipeline() {
    return {
      processors: this.getProcessors()
    };
  }
  getPipeline$() {
    return this.pipeline$.asObservable();
  }
  getPipeline() {
    return this.pipeline$.getValue();
  }
  getBasicProcessors(inferenceConfigOverrides) {
    var _this$deploymentId;
    const processor = {
      inference: {
        model_id: (_this$deploymentId = this.deploymentId) !== null && _this$deploymentId !== void 0 ? _this$deploymentId : this.model.model_id,
        target_field: this.inferenceType,
        field_map: {
          [this.inputField$.getValue()]: this.modelInputField
        },
        ...(inferenceConfigOverrides && Object.keys(inferenceConfigOverrides).length ? {
          inference_config: this.getInferenceConfig(inferenceConfigOverrides)
        } : {})
      }
    };
    return [processor];
  }
  getInferenceConfig(inferenceConfigOverrides) {
    return {
      [this.inferenceType]: {
        ...inferenceConfigOverrides
      }
    };
  }
  async runInfer(getInferenceConfig, processResponse) {
    try {
      this.setRunning();
      const inputText = this.inputText$.getValue()[0];
      const inferenceConfig = getInferenceConfig();
      const resp = await this.trainedModelsApi.inferTrainedModel(this.model.model_id, this.deploymentId, {
        docs: this.getInferDocs(),
        ...(inferenceConfig ? {
          inference_config: inferenceConfig
        } : {})
      }, DEFAULT_INFERENCE_TIME_OUT);
      const processedResponse = processResponse(resp, inputText);
      this.inferenceResult$.next([processedResponse]);
      this.setFinished();
      return [processedResponse];
    } catch (error) {
      this.setFinishedWithErrors(error);
      throw error;
    }
  }
  async runPipelineSimulate(processResponse) {
    try {
      this.setRunning();
      const {
        docs
      } = await this.trainedModelsApi.trainedModelPipelineSimulate(this.getPipeline(), this.getPipelineDocs());
      const processedResponse = docs.map(d => processResponse(this.getDocFromResponse(d)));
      this.inferenceResult$.next(processedResponse);
      this.setFinished();
      return processedResponse;
    } catch (error) {
      this.setFinishedWithErrors(error);
      throw error;
    }
  }
  getInferDocs() {
    return [{
      [this.inputField$.getValue()]: this.inputText$.getValue()[0]
    }];
  }
  getPipelineDocs() {
    return this.inputText$.getValue().map(v => ({
      _source: {
        [this.inputField$.getValue()]: v
      }
    }));
  }
  getDefaultInferenceConfig() {
    return this.model.inference_config[this.inferenceType];
  }
  getNumTopClassesConfig(defaultOverride = 5) {
    var _options$num_top_clas;
    const options = this.getDefaultInferenceConfig();
    if (options && 'num_top_classes' in options && ((_options$num_top_clas = options === null || options === void 0 ? void 0 : options.num_top_classes) !== null && _options$num_top_clas !== void 0 ? _options$num_top_clas : 0 > 0)) {
      return {};
    }
    return {
      num_top_classes: defaultOverride
    };
  }

  // @ts-expect-error error does not exist in type
  getDocFromResponse({
    doc,
    error
  }) {
    if (doc === undefined) {
      if (error) {
        this.setFinishedWithErrors(error);
        throw Error(error.reason);
      }
      throw Error(_i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.pipelineSimulate.unknownError', {
        defaultMessage: 'Error simulating ingest pipeline'
      }));
    }
    return doc;
  }
}
exports.InferenceBase = InferenceBase;