"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteModelsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _trained_models = require("../services/ml_api_service/trained_models");
var _toast_notification_service = require("../services/toast_notification_service");
var _delete_space_aware_item_check_modal = require("../components/delete_space_aware_item_check_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteModelsModal = ({
  modelIds,
  onClose
}) => {
  const trainedModelsApiService = (0, _trained_models.useTrainedModelsApiService)();
  const {
    displayErrorToast,
    displaySuccessToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const [canDeleteModel, setCanDeleteModel] = (0, _react.useState)(false);
  const deleteModels = (0, _react.useCallback)(async () => {
    try {
      await Promise.all(modelIds.map(modelId => trainedModelsApiService.deleteTrainedModel(modelId)));
      displaySuccessToast(_i18n.i18n.translate('xpack.ml.trainedModels.modelsList.successfullyDeletedMessage', {
        defaultMessage: '{modelsCount, plural, one {Model {modelIds}} other {# models}} {modelsCount, plural, one {has} other {have}} been successfully deleted',
        values: {
          modelsCount: modelIds.length,
          modelIds: modelIds.join(', ')
        }
      }));
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.fetchDeletionErrorMessage', {
        defaultMessage: '{modelsCount, plural, one {Model} other {Models}} deletion failed',
        values: {
          modelsCount: modelIds.length
        }
      }));
    }
    onClose(true);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [modelIds, trainedModelsApiService]);
  return canDeleteModel ? /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose.bind(null, false),
    initialFocus: "[name=cancelModelDeletion]",
    "data-test-subj": "mlModelsDeleteModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.deleteModal.header",
    defaultMessage: "Delete {modelsCount, plural, one {{modelId}} other {# models}}?",
    values: {
      modelId: modelIds[0],
      modelsCount: modelIds.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose.bind(null, false),
    name: "cancelModelDeletion"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.deleteModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: deleteModels.bind(null),
    fill: true,
    color: "danger",
    "data-test-subj": "mlModelsDeleteModalConfirmButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.deleteModal.deleteButtonLabel",
    defaultMessage: "Delete"
  })))) : /*#__PURE__*/_react.default.createElement(_delete_space_aware_item_check_modal.DeleteSpaceAwareItemCheckModal, {
    ids: modelIds,
    mlSavedObjectType: "trained-model",
    canDeleteCallback: setCanDeleteModel.bind(null, true),
    onCloseCallback: onClose.bind(null, true),
    refreshJobsCallback: () => {},
    hasManagedJob: false
  });
};
exports.DeleteModelsModal = DeleteModelsModal;